jQuery(document).ready(function ($) {
	// info widget
	function media_upload(button_selector) {
		var _custom_media = true,
			_orig_send_attachment = wp.media.editor.send.attachment;
		$("body").on("click", button_selector, function () {
			var button_id = $(this).attr("id");
			wp.media.editor.send.attachment = function (props, attachment) {
				if (_custom_media) {
					$("." + button_id + "_img").attr("src", attachment.url);
					$("." + button_id + "_url").val(attachment.url);
				} else {
					return _orig_send_attachment.apply($("#" + button_id), [
						props,
						attachment,
					]);
				}
			};
			wp.media.editor.open($("#" + button_id));
			return false;
		});
	}
	media_upload(".js_custom_upload_media");
	// !info widget

	// Gallery widget
	var file_frame;
	var widget_id;

	$(document).on("click", ".custom_widget_image_upload", function (event) {
		event.preventDefault();
		widget_id = $(this).closest(".widget").attr("id");

		if (file_frame) {
			file_frame.open();
			return;
		}

		file_frame = wp.media.frames.file_frame = wp.media({
			title: "Select Images",
			button: {
				text: "Select Images",
			},
			multiple: true, // Allow multiple selections
		});

		file_frame.on("select", function () {
			var attachments = file_frame.state().get("selection").toJSON();
			var imageUrls = "";

			for (var i = 0; i < attachments.length; i++) {
				imageUrls +=
					'<img src="' +
					attachments[i].url +
					'" style="max-width: 100px; height: auto;" /><br />';
			}

			$("#" + widget_id + " .custom-widget-images").html(imageUrls);
			$("#" + widget_id + " .custom-widget-image-ids").val(
				attachments
					.map(function (item) {
						return item.id;
					})
					.join(",")
			);
		});

		file_frame.open();
	});
	// !Gallery widget
});
