<?php

/**
 * TJ Footer Builder
 *
 * @author 		ThemeJunction 
 * @package 	TJCore
 * @version 	1.0.0
 * 
 * Class TJ_Footer_Builder
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

class TJ_Footer_Builder {

  // Construct
  function __construct() {
    add_action('init', array($this, 'register_custom_post_type'));
  }

  // Register Custom Post Type
  public function register_custom_post_type() {

    $labels = array(
      'name'                  => esc_html_x('TJ Footer Builder', 'Post Type General Name', 'tjcore'),
      'singular_name'         => esc_html_x('TJ Footer Builder', 'Post Type Singular Name', 'tjcore'),
      'menu_name'             => esc_html__('TJ Footer Builder', 'tjcore'),
      'add_new_item'          => esc_html__('Add New Footer', 'tjcore'),
      'edit_item'             => esc_html__('Edit Footer', 'tjcore'),
      'new_item'              => esc_html__('New Footer', 'tjcore'),
      'view_item'             => esc_html__('View Footer', 'tjcore'),
      'search_items'          => esc_html__('Search Footer', 'tjcore'),
      'not_found'             => esc_html__('Not Footer found', 'tjcore'),
      'parent_item_colon'     => esc_html__('Parent Footer:', 'tjcore'),
      'not_found_in_trash'    => esc_html__('No Footer found in Trash', 'tjcore'),
    );

    $args   = array(
      'labels'                => $labels,
      'public'                => true,
      'show_in_menu'          => 'themes.php',
      'menu_icon' => '',
      'supports'              => ['title', 'elementor'],
      'capability_type' => 'post',
    );

    register_post_type('tj-footer-builder', $args);
    flush_rewrite_rules(false);
  }
}
new TJ_Footer_Builder();
