<?php
$accordionList = (isset($settings['tj_accordion_list']) && !empty($settings['tj_accordion_list'])) ? $settings['tj_accordion_list'] : array();
$accordion_id  = $this->get_id();

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $accordionClass = "tj-faq-style-two wow $tjAnimationName";
  $this->add_render_attribute('tj-accordion-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $accordionClass = "tj-faq-style-two";
}
$this->add_render_attribute('tj-accordion-arg', 'class', $accordionClass);
?>



<div <?php echo $this->get_render_attribute_string('tj-accordion-arg'); ?>>
  <?php if (!empty($accordionList)) : ?>
    <div class="accordion tj-faq-style" id="accordion-<?php echo esc_attr($accordion_id); ?>">
      <?php foreach ($accordionList as $key => $accordion) :

        $is_expand     = $accordion['is_expand'];
      ?>
        <div class="accordion-item <?php echo esc_attr(('yes' == $is_expand) ? "active" : ""); ?>">
          <h2 class="accordion-header">
            <button class="accordion-button <?php echo esc_attr(('yes' != $is_expand) ? "collapsed" : ""); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#accordion-<?php echo esc_attr($accordion_id . "-" . ($key + 1)); ?>" aria-expanded="<?php echo esc_attr(('yes' == $is_expand) ? "true" : "false"); ?>">

              <?php printf("<span>0%s</span> %s", $key + 1, tj_kses($accordion['tj_accordion_question'])) ?>

            </button>
          </h2>
          <div id="accordion-<?php echo esc_attr($accordion_id . "-" . ($key + 1)); ?>" class="accordion-collapse collapse <?php echo esc_attr(('yes' == $is_expand) ? "show" : ""); ?>" data-bs-parent="#accordion-<?php echo esc_attr($accordion_id); ?>">
            <div class="accordion-body">
              <?php echo tj_kses($accordion['tj_accordion_answer']); ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>

    </div>

  <?php endif; ?>
</div>