<?php
// images
$image1 = !empty($settings['tj_image_1']['url']) ? $settings['tj_image_1']['url'] : "";
$image2 = !empty($settings['tj_image_2']['url']) ? $settings['tj_image_2']['url'] : "";
$image3 = !empty($settings['tj_image_3']['url']) ? $settings['tj_image_3']['url'] : "";

// shapes
$shape1 = !empty($settings['tj_shape_1']['url']) ? $settings['tj_shape_1']['url'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $imageClass = "animation-image-wrap wow $tjAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $imageClass = "animation-image-wrap";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
  <div class="animated-image-group pulse">

    <?php if (!empty($image1)) : ?>
      <div class="group-image">
        <img src="<?php echo esc_url($image1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif; ?>

    <?php if (!empty($image2)) : ?>
      <div class="faq-image2 pulse">
        <img src="<?php echo esc_url($image2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif; ?>

  </div>

  <?php if (!empty($image3)) : ?>
    <div class="faq-image3 pulse">
      <img src="<?php echo esc_url($image3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

  <?php if (!empty($shape1)) : ?>
    <div class="image-shape pulse">
      <img src="<?php echo esc_url($shape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

</div>