<?php
// images
$image1 = !empty($settings['tj_image_1']['url']) ? $settings['tj_image_1']['url'] : "";
$image2 = !empty($settings['tj_image_2']['url']) ? $settings['tj_image_2']['url'] : "";
$image3 = !empty($settings['tj_image_3']['url']) ? $settings['tj_image_3']['url'] : "";
$image4 = !empty($settings['tj_image_4']['url']) ? $settings['tj_image_4']['url'] : "";

// shapes
$shape1 = !empty($settings['tj_shape_1']['url']) ? $settings['tj_shape_1']['url'] : "";
$shape2 = !empty($settings['tj_shape_2']['url']) ? $settings['tj_shape_2']['url'] : "";
$shape3 = !empty($settings['tj_shape_3']['url']) ? $settings['tj_shape_3']['url'] : "";
$shape4 = !empty($settings['tj_shape_4']['url']) ? $settings['tj_shape_4']['url'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $imageClass = "faq-image-group style-8 wow $tjAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $imageClass = "faq-image-group style-8";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>

  <?php if (!empty($image1)) : ?>
    <div class="faq-image-one pulse">
      <div class="group-image">
        <img src="<?php echo esc_url($image1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>

      <?php if (!empty($shape1)) : ?>
        <img class="group-shape pulse" src="<?php echo esc_url($shape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
      <?php endif;  ?>

      <?php if (!empty($shape2)) : ?>
        <img class="group-shape1 shake-y" src="<?php echo esc_url($shape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($image3)) : ?>
    <div class="faq-image3 pulse">
      <img src="<?php echo esc_url($image3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

  <?php if (!empty($image2)) : ?>
    <div class="faq-image2 pulse">
      <div class="group-image">
        <img src="<?php echo esc_url($image2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>

      <?php if (!empty($shape3)) : ?>
        <img class="group-shape pulse" src="<?php echo esc_url($shape3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
      <?php endif; ?>

      <?php if (!empty($shape4)) : ?>
        <img class="group-shape1 shake-y" src="<?php echo esc_url($shape4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_4']['id'], '_wp_attachment_image_alt', true)); ?>" />
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($image4)) : ?>
    <div class="faq-image4 pulse">
      <img src="<?php echo esc_url($image4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_4']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
</div>