<?php
$tjCounterCount   = (!empty($settings['tj_ff_number'])) ? $settings['tj_ff_number'] : "";
$tjCounterPrefix   = (!empty($settings['tj_ff_prefix'])) ? $settings['tj_ff_prefix'] : "";
$tjCounterSuffix  = (!empty($settings['tj_ff_suffix'])) ? $settings['tj_ff_suffix'] : "";
$tjCounterTitle   = (!empty($settings['tj_ff_title'])) ? $settings['tj_ff_title'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $counterClass = "counter-item-two tj-counter wow $tjAnimationName";
  $this->add_render_attribute('tj-counter-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $counterClass = "counter-item-two tj-counter";
}
$this->add_render_attribute('tj-counter-arg', 'class', $counterClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-counter-arg'); ?>>
  <?php if (!empty($tjCounterCount)) : ?>
    <div class="tj-count">
      <span><?php echo esc_html($tjCounterPrefix); ?></span>
      <span class="odometer" data-count="<?php echo esc_attr($tjCounterCount); ?>"><?php esc_html_e('0', 'tjcore'); ?></span>
      <span><?php echo esc_html($tjCounterSuffix); ?></span>
    </div>
  <?php endif; ?>
  <?php if (!empty($tjCounterTitle)) : ?>
    <span class="sub-title"><?php echo tj_kses($tjCounterTitle); ?></span>
  <?php endif; ?>
</div>