<?php
$ctaSubtitle = (!empty($settings['tj_subtitle'])) ? $settings['tj_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "white-sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "white-sub-title";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);


// title
$ctaTitle   = (!empty($settings['tj_title'])) ? $settings['tj_title'] : "";
$ctaTitleTag   = (!empty($settings['tj_title_tag'])) ? $settings['tj_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);


$ctaButtonSwitcher   = (isset($settings['tj_btn_button_show']) ? $settings['tj_btn_button_show'] : '');
$ctaButtonText   = (isset($settings['tj_btn_text']) ? $settings['tj_btn_text'] : '');
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

if (!empty($tjButtonAnimation)) {
  $buttonClass = "btn tj-black-btn wow $tjButtonAnimationName";
  $buttonAnimationDelay = $tjButtonAnimationDelay['size'];
} else {
  $buttonClass = "btn tj-black-btn";
  $buttonAnimationDelay = '';
}
// Link
if ('2' == $settings['tj_btn_link_type']) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($settings['tj_btn_page_link']));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
} else {
  if (!empty($settings['tj_btn_link']['url'])) {
    $this->add_link_attributes('tj-button-arg', $settings['tj_btn_link']);
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
  }
}

?>

<!-- start: CTA Area -->
<section class="tj-cta-section">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="cta-content-area text-center">
          <div class="tj-sec-heading">

            <?php if (!empty($ctaSubtitle)) : ?>
              <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
                <?php echo esc_html__($ctaSubtitle, "tjcore"); ?>
              </span>
            <?php endif; ?>

            <?php if (!empty($ctaTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($ctaTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($ctaTitle)
              );
            endif; ?>

            <?php if (!empty($ctaButtonSwitcher && $ctaButtonText)) : ?>
              <div class="cta-button">
                <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
                  <?php echo esc_html__($ctaButtonText, 'tjcore'); ?>
                </a>
              </div>
            <?php endif; ?>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- end: CTA Area -->