<?php
// title
$ctaTitle   = (!empty($settings['tj_title'])) ? $settings['tj_title'] : "";
$ctaTitleTag   = (!empty($settings['tj_title_tag'])) ? $settings['tj_title_tag'] : "";

$ctaShape1   = (!empty($settings['tj_cta_shape_1']['url'])) ? $settings['tj_cta_shape_1']['url'] : "";
$ctaShape2   = (!empty($settings['tj_cta_shape_2']['url'])) ? $settings['tj_cta_shape_2']['url'] : "";

$this->add_render_attribute('title_args', 'class', "title");

$ctaFormShortcode   = (!empty($settings['tj_form_shortcode'])) ? $settings['tj_form_shortcode'] : "";

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $sectionClass = "tj-cta-section style-9 wow $tjAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $sectionClass = "tj-cta-section style-9";
}
$this->add_render_attribute('section_args', 'class', $sectionClass);

?>

<div <?php echo $this->get_render_attribute_string('section_args'); ?>>
  <div class="row">
    <div class="col">
      <div class="cta_wrapper">
        <div class="cta_content">

          <?php if (!empty($ctaTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($ctaTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($ctaTitle)
            );
          endif; ?>
        </div>
        <?php if (!empty($ctaFormShortcode)) : ?>
          <div class="cta_form">
            <?php echo do_shortcode($ctaFormShortcode); ?>
          </div>
        <?php endif; ?>

        <?php if (!empty($ctaShape1)) :  ?>
          <div class="cta-one">
            <img src="<?php echo esc_url($ctaShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_cta_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>

        <?php if (!empty($ctaShape2)) :  ?>
          <div class="cta-two">
            <img src="<?php echo esc_url($ctaShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_cta_shape_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>