<?php
$this->add_render_attribute('title_args', 'class', 'title');

if (!empty($settings['tj_feature_link']['url'])) {
  $this->add_link_attributes('tj_feature_link', $settings['tj_feature_link']);
}

$title    = (isset($settings['tj_feature_title']) ? $settings['tj_feature_title'] : '');
$description    = (isset($settings['tj_feature_desc']) ? $settings['tj_feature_desc'] : '');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $featureClass = "about_feature_item wow $tjAnimationName";
  $this->add_render_attribute('tj-feature-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $featureClass = "about_feature_item";
}
$this->add_render_attribute('tj-feature-arg', 'class', $featureClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-feature-arg'); ?>>
  <div class="about_icon_wrap">

    <?php if ($settings['tj_feature_icon_type'] !== 'image') : ?>

      <?php if (!empty($settings['tj_icon']) || !empty($settings['tj_selected_icon']['value'])) : ?>
        <div class="about-icon">
          <?php tj_render_icon($settings, 'tj_icon', 'tj_selected_icon'); ?>
        </div>
      <?php endif;

    else : ?>
      <?php if (!empty($settings['tj_icon_image']['url'])) : ?>
        <div class="about-icon image">
          <img class="feature_icon_img" src="<?php echo esc_url($settings['tj_icon_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($settings['tj_icon_image']['url']), '_wp_attachment_image_alt', true)); ?>">
        </div>
      <?php endif; ?>
    <?php endif; ?>

  </div>

  <div class="about-text">
    <?php if ($title) :

      $titleTag = tag_escape($settings['tj_feature_title_tag']);
    ?>
      <<?php echo esc_attr($titleTag); ?> <?php echo $this->get_render_attribute_string('title_args'); ?>>

        <?php if (!empty($settings['tj_feature_link']['url'])) : ?>
          <a <?php echo $this->get_render_attribute_string('tj_feature_link'); ?>><?php echo  tj_kses($title); ?></a>
        <?php else :
          echo  tj_kses($title);
        endif; ?>
      </<?php echo esc_attr($titleTag); ?>>
    <?php endif; ?>

    <?php if (!empty($description)) : ?>
      <p><?php echo tj_kses($description); ?></p>
    <?php endif; ?>
  </div>
</div>