<?php
$footerTitle  = (!empty($settings['tj_footer_title'])) ? $settings['tj_footer_title'] : "";
$footerContactList   = (!empty($settings['contact_list'])) ? $settings['contact_list'] : "";

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $sectionClass = "footer-widget tj_footer_widget contact_info wow $tjAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $sectionClass = "footer-widget tj_footer_widget contact_info";
}
$this->add_render_attribute('section_args', 'class', $sectionClass);
?>

<div <?php echo $this->get_render_attribute_string('section_args'); ?>>

  <?php if (!empty($footerTitle)) : ?>
    <h4 class="footer_title"><?php echo esc_html__($footerTitle, 'tjcore'); ?></h4>
  <?php endif; ?>

  <?php if (!empty($footerContactList)) : ?>
    <ul class="contact_list">

      <?php foreach ($footerContactList as $contact) :

        $link = !empty($contact['tj_contact_link']['url']) ? $contact['tj_contact_link']['url'] : '';
        $target = !empty($contact['tj_contact_link']['is_external']) ? '_blank' : '';
        $rel = !empty($contact['tj_contact_link']['nofollow']) ? 'nofollow' : '';
      ?>
        <li>
          <span class="icon"><?php tj_render_icon($contact, 'tj_contact_icon', 'contact_icon'); ?></span>

          <?php if (!empty($link)) :
            $href = 'href=' . $link . '';
            if (!empty($target)) :
              $target = 'target=' . $target . '';
            endif;
            if (!empty($rel)) :
              $rel = 'rel=' . $rel . '';
            endif;
          ?>
            <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
              <?php echo esc_attr($contact['tj_contact_label']); ?>
            </a>
          <?php else : ?>
            <p><?php echo esc_attr($contact['tj_contact_label']); ?></p>
          <?php endif; ?>

        </li>
      <?php endforeach; ?>

    </ul>
  <?php endif; ?>
</div>