<?php
$footerTitle  = (!empty($settings['tj_footer_title'])) ? $settings['tj_footer_title'] : "";
$footerGalleryImages   = (!empty($settings['tj_footer_gallery'])) ? $settings['tj_footer_gallery'] : "";

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $sectionClass = "footer-widget tj_footer_widget footer_gallery wow $tjAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $sectionClass = "footer-widget tj_footer_widget footer_gallery";
}
$this->add_render_attribute('section_args', 'class', $sectionClass);
?>


<div <?php echo $this->get_render_attribute_string('section_args'); ?>>
  <?php if (!empty($footerTitle)) : ?>
    <h4 class="footer_title"><?php echo esc_html__($footerTitle, 'tjcore'); ?></h4>
  <?php endif; ?>

  <?php if (!empty($footerGalleryImages)) : ?>
    <div class="gallery_images popup-gallery">

      <?php foreach ($footerGalleryImages as $image) : ?>
        <a class="gallery_item" href="<?php echo esc_url($image['url']); ?>" data-bg-image="<?php echo esc_url($image['url']); ?>">
          <div class="gallery-icon">
            <i class="fa-regular fa-plus"></i>
          </div>
        </a>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

</div>