<?php
$footerLogo   = (!empty($settings['tj_footer_logo']['url'])) ? $settings['tj_footer_logo']['url'] : "";
$footerLogoLink   = (!empty($settings['tj_footer_logo_link'])) ? $settings['tj_footer_logo_link'] : "";
$footerDesc   = (!empty($settings['tj_footer_desc'])) ? $settings['tj_footer_desc'] : "";
$footerSocials   = (!empty($settings['socials_list'])) ? $settings['socials_list'] : "";

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $sectionClass = "footer-widget tj_footer_widget wow $tjAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $sectionClass = "footer-widget tj_footer_widget";
}
$this->add_render_attribute('section_args', 'class', $sectionClass);
?>

<div <?php echo $this->get_render_attribute_string('section_args'); ?>>
  <?php if (!empty($footerLogo)) : ?>
    <div class="footer-logo">
      <?php if (!empty($footerLogoLink)) : ?>
        <a href="<?php echo esc_attr($footerLogoLink); ?>">
          <img src="<?php echo esc_url($footerLogo); ?>" alt="<?php echo get_post_meta($settings['tj_footer_logo']['id'], '_wp_attachment_image_alt', true); ?>" />
        </a>
      <?php else : ?>
        <img src="<?php echo esc_url($footerLogo); ?>" alt="<?php echo get_post_meta($settings['tj_footer_logo']['id'], '_wp_attachment_image_alt', true); ?>" />
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($footerDesc)) : ?>
    <div class="desc">
      <p><?php echo tj_kses($footerDesc); ?></p>
    </div>
  <?php endif; ?>

  <?php if (!empty($footerSocials)) : ?>
    <ul class="footer-share">

      <?php foreach ($footerSocials as $social) :

        $link = !empty($social['tj_social_link']['url']) ? $social['tj_social_link']['url'] : '';
        $target = !empty($social['tj_social_link']['is_external']) ? '_blank' : '';
        $rel = !empty($social['tj_social_link']['nofollow']) ? 'nofollow' : '';
      ?>
        <li>
          <?php if (!empty($link)) :
            $href = 'href=' . $link . '';
            if (!empty($target)) :
              $target = 'target=' . $target . '';
            endif;
            if (!empty($rel)) :
              $rel = 'rel=' . $rel . '';
            endif;
          ?>
            <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
              <?php tj_render_icon($social, 'tj_social_icon', 'social_icon'); ?>
            </a>
          <?php else :
            tj_render_icon($social, 'tj_social_icon', 'social_icon');
          endif;
          ?>
        </li>
      <?php endforeach; ?>
    </ul>
  <?php endif; ?>
</div>