<?php
$isHeaderAbsolute = ("yes" == $settings['is_header_absolute']) ? "header-absolute" : false;
$isHeaderSticky = ('yes' == $settings['is_header_sticky']) ? "header-sticky" : false;

$tjLogo = !empty($settings['tj_logo']['url']) ? $settings['tj_logo']['url'] : '';

$tjNavigation   = !empty($settings['tj_navigation']) ? $settings['tj_navigation'] : 0;


// topbar
$tjShowTopbar   = !empty($settings['show_header_topbar']) ? $settings['show_header_topbar'] : false;
$tjTopContactList   = !empty($settings['tj_contact_list']) ? $settings['tj_contact_list'] : '';
$tjTopSocialsList   = !empty($settings['tj_socials_list']) ? $settings['tj_socials_list'] : '';

// button
$showHeaderButton = (!empty($settings['is_header_btn'])) ? $settings['is_header_btn'] : false;
$tjBtnText = (!empty($settings['tj_btn_text'])) ? $settings['tj_btn_text'] : "";
$tjBtnLinkType = (!empty($settings['tj_btn_link_type'])) ? $settings['tj_btn_link_type'] : 1;
$tjBtnLink = (!empty($settings['tj_btn_link'])) ? $settings['tj_btn_link'] : "";
$tjBtnPageLink = (!empty($settings['tj_btn_page_link'])) ? $settings['tj_btn_page_link'] : "";

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', "btn tj-black-btn-two style-9");
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', "btn tj-black-btn-two style-9");
  }
}
?>
<header class="tj-header-area style-9 <?php printf("%s", esc_attr($isHeaderAbsolute)); ?>">

  <?php if ("yes" == $tjShowTopbar) : ?>
    <div class="header-topbar style-9">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="topbar-content-area">

              <?php if (!empty($tjTopContactList)) : ?>
                <div class="topbar-infos">
                  <ul class="dot-style">
                    <?php foreach ($tjTopContactList as $contact) :

                      $link = !empty($contact['tj_contact_link']['url']) ? $contact['tj_contact_link']['url'] : '';
                      $target = !empty($contact['tj_contact_link']['is_external']) ? '_blank' : '';
                      $rel = !empty($contact['tj_contact_link']['nofollow']) ? 'nofollow' : '';
                    ?>
                      <li>
                        <?php if (!empty($link)) :
                          $href = 'href=' . $link . '';
                          if (!empty($target)) :
                            $target = 'target=' . $target . '';
                          endif;
                          if (!empty($rel)) :
                            $rel = 'rel=' . $rel . '';
                          endif; ?>
                          <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                            <?php tj_render_icon($contact, 'contact_icon', 'tj_contact_icon'); ?>
                            <?php echo esc_html($contact['tj_contact_label']); ?>
                          </a>
                        <?php else : ?>
                          <?php tj_render_icon($contact, 'contact_icon', 'tj_contact_icon'); ?>
                          <?php echo esc_html($contact['tj_contact_label']); ?>
                        <?php endif; ?>
                      </li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>

              <?php if (!empty($tjTopSocialsList)) : ?>
                <div class="topbar-share9">
                  <ul class="dot-style">
                    <?php foreach ($tjTopSocialsList as $social) :

                      $link = !empty($social['tj_social_link']['url']) ? $social['tj_social_link']['url'] : '';
                      $target = !empty($social['tj_social_link']['is_external']) ? '_blank' : '';
                      $rel = !empty($social['tj_social_link']['nofollow']) ? 'nofollow' : '';
                    ?>
                      <li>
                        <?php if (!empty($link)) :
                          $href = 'href=' . $link . '';
                          if (!empty($target)) :
                            $target = 'target=' . $target . '';
                          endif;
                          if (!empty($rel)) :
                            $rel = 'rel=' . $rel . '';
                          endif;
                        ?>
                          <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                            <?php tj_render_icon($social, 'social_icon', 'tj_social_icon'); ?>
                          </a>
                        <?php else :
                          tj_render_icon($social, 'social_icon', 'tj_social_icon');
                        endif;
                        ?>
                      </li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>


  <div class="menu-area style-9">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-12">
          <div class="menu-content-area">

            <?php if (!empty($tjLogo)) : ?>
              <!-- logo -->
              <div class="site-logo logo-area">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                  <img src="<?php echo esc_url($tjLogo); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_logo']['id'], '_wp_attachment_image_alt', true)); ?>" />
                </a>
              </div>
            <?php endif; ?>

            <?php if ($tjNavigation > 0) : ?>
              <!-- navigation -->
              <div class="tj-menu-area d-lg-block d-none" id="mainMenu-<?php echo $this->get_id(); ?>">
                <?php wp_nav_menu(array('menu' => $tjNavigation)) ?>
              </div>
            <?php endif; ?>

            <?php if (!empty($showHeaderButton)) : ?>
              <!-- button -->
              <div class="header-button d-flex d-none d-lg-block">
                <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
                  <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
                  <i class="fa-sharp fa-light fa-circle-plus"></i>
                </a>
              </div>
            <?php endif; ?>

            <div class="tj-canva-two d-lg-none">
              <a class="menuBar nav-menu-link menu-button" href="javascript:void(0)">
                <?php if (!empty($settings['tj_hamburger_icon']['value'])) : ?>
                  <?php tj_render_icon($settings, 'tj_hamburger_icon', 'hamburger_icon'); ?>
                <?php else : ?>
                  <span class="dot1"></span>
                  <span class="dot2"></span>
                  <span class="dot3"></span>
                  <span class="dot4"></span>
                <?php endif; ?>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<header class="tj-header-area style-9 header-duplicate <?php printf("%s", esc_attr($isHeaderSticky)); ?>">
  <div class="menu-area style-9">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-12">
          <div class="menu-content-area">

            <?php if (!empty($tjLogo)) : ?>
              <!-- logo -->
              <div class="site-logo logo-area">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                  <img src="<?php echo esc_url($tjLogo); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_logo']['id'], '_wp_attachment_image_alt', true)); ?>" />
                </a>
              </div>
            <?php endif; ?>

            <?php if ($tjNavigation > 0) : ?>
              <!-- navigation -->
              <div class="tj-menu-area d-lg-block d-none">
                <?php wp_nav_menu(array('menu' => $tjNavigation)) ?>
              </div>
            <?php endif; ?>

            <?php if (!empty($showHeaderButton)) : ?>
              <!-- button -->
              <div class="header-button d-flex d-none d-lg-block">
                <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
                  <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
                  <i class="fa-sharp fa-light fa-circle-plus"></i>
                </a>
              </div>
            <?php endif; ?>

            <div class="tj-canva-two d-lg-none">
              <a class="menuBar nav-menu-link menu-button" href="javascript:void(0)">
                <?php if (!empty($settings['tj_hamburger_icon']['value'])) : ?>
                  <?php tj_render_icon($settings, 'tj_hamburger_icon', 'hamburger_icon'); ?>
                <?php else : ?>
                  <span class="dot1"></span>
                  <span class="dot2"></span>
                  <span class="dot3"></span>
                  <span class="dot4"></span>
                <?php endif; ?>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>




<!-- Mobile Menu -->
<?php
$tjMobileLogo = !empty($settings['tj_mobile_logo']['url']) ? $settings['tj_mobile_logo']['url'] : '';
$tjSearch   = !empty($settings['is_mobile_search']) ? $settings['is_mobile_search'] : false;
$tjContactList   = !empty($settings['contact_list']) ? $settings['contact_list'] : "";
$tjSocialsList   = !empty($settings['socials_list']) ? $settings['socials_list'] : "";

// button
$showMobileButton = (!empty($settings['is_mobile_header_btn'])) ? $settings['is_mobile_header_btn'] : false;
$tjMobileBtnText = (!empty($settings['tj_mobile_btn_text'])) ? $settings['tj_mobile_btn_text'] : "";
$tjMobileBtnLinkType = (!empty($settings['tj_mobile_btn_link_type'])) ? $settings['tj_mobile_btn_link_type'] : 1;
$tjMobileBtnLink = (!empty($settings['tj_mobile_btn_link'])) ? $settings['tj_mobile_btn_link'] : "";
$tjMobileBtnPageLink = (!empty($settings['tj_mobile_btn_page_link'])) ? $settings['tj_mobile_btn_page_link'] : "";

if ('2' == $tjMobileBtnLinkType) {
  $this->add_render_attribute('tj-mobile-button-arg', 'href', get_permalink($tjMobileBtnPageLink));
  $this->add_render_attribute('tj-mobile-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-mobile-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-mobile-button-arg', 'class', "btn tj-black-btn");
} else {
  if (!empty($tjMobileBtnLink['url'])) {
    $this->add_link_attributes('tj-mobile-button-arg', $tjMobileBtnLink);
    $this->add_render_attribute('tj-mobile-button-arg', 'class', "btn tj-black-btn");
  }
}
?>
<div id="tjMenuOverlay" class="tj-overlay-canvas d-lg-none"></div>
<div class="tj-offcanvas-area d-lg-none">
  <div class="tj-offcanvas-header d-flex align-items-center justify-content-between">

    <?php if (!empty($tjMobileLogo)) : ?>
      <!-- mobile logo -->
      <div class="logo-area text-center">
        <a class="mobile-logo" href="<?php echo esc_url(home_url('/')); ?>">
          <img src="<?php echo esc_url($tjMobileLogo); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_mobile_logo']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </a>
      </div>
    <?php endif; ?>

    <div class="offcanvas-icon">
      <button id="menuClose">
        <i class="fa-light fa-xmark"></i>
      </button>
    </div>

  </div>

  <?php if ("yes" == $tjSearch) : ?>
    <!-- search -->
    <div class="tj-search-box">
      <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
        <button type="submit"><i class="fal fa-search"></i></button>
        <input type="search" autocomplete="off" name="s" value="<?php echo esc_attr(get_search_query()) ?>" placeholder="<?php echo esc_attr('Search...'); ?>">
      </form>
    </div>
  <?php endif; ?>

  <nav class="right_menu_togle mobile-navbar-menu d-lg-none" id="mobileMenu-<?php echo $this->get_id(); ?>"></nav>

  <?php if (!empty($tjContactList)) : ?>
    <!-- contact list -->
    <div class="mobile-contact">
      <div class="contact-menu">
        <ul class="dot-style">
          <?php foreach ($tjContactList as $contact) :

            $link = !empty($contact['contact_link']['url']) ? $contact['contact_link']['url'] : '';
            $target = !empty($contact['contact_link']['is_external']) ? '_blank' : '';
            $rel = !empty($contact['contact_link']['nofollow']) ? 'nofollow' : '';
          ?>
            <li>
              <span><?php tj_render_icon($contact, 'contact_icon', 'tj_contact_icon'); ?></span>

              <?php if (!empty($link)) :
                $href = 'href=' . $link . '';
                if (!empty($target)) :
                  $target = 'target=' . $target . '';
                endif;
                if (!empty($rel)) :
                  $rel = 'rel=' . $rel . '';
                endif; ?>
                <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                  <?php echo esc_html($contact['contact_label']); ?>
                </a>
              <?php else : ?>
                <p><?php echo esc_html($contact['contact_label']); ?></p>
              <?php endif; ?>
            </li>
          <?php endforeach; ?>

        </ul>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($tjSocialsList)) : ?>
    <!-- socials -->
    <div class="mobile-share">
      <ul class="dot-style">

        <?php foreach ($tjSocialsList as $social) :

          $link = !empty($social['social_link']['url']) ? $social['social_link']['url'] : '';
          $target = !empty($social['social_link']['is_external']) ? '_blank' : '';
          $rel = !empty($social['social_link']['nofollow']) ? 'nofollow' : '';
        ?>
          <li>
            <?php if (!empty($link)) :
              $href = 'href=' . $link . '';
              if (!empty($target)) :
                $target = 'target=' . $target . '';
              endif;
              if (!empty($rel)) :
                $rel = 'rel=' . $rel . '';
              endif;
            ?>
              <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                <?php tj_render_icon($social, 'social_icon', 'tj_social_icon'); ?>
              </a>
            <?php else :
              tj_render_icon($social, 'social_icon', 'tj_social_icon');
            endif;
            ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php if ("yes" == $showMobileButton) : ?>
    <!-- mobile button -->
    <div class="header-button">
      <a <?php echo $this->get_render_attribute_string('tj-mobile-button-arg'); ?>>
        <?php echo esc_html__($tjMobileBtnText, 'tjcore'); ?>
      </a>
    </div>
  <?php endif; ?>

</div>