<?php
// subtitle
$tjHeroBannerSubtitle   = (!empty($settings['tj_hero_banner_subtitle'])) ? $settings['tj_hero_banner_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "hero-sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "hero-sub-title";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);

// title
$tjHeroBannerTitle   = (!empty($settings['tj_hero_banner_title'])) ? $settings['tj_hero_banner_title'] : "";
$tjHeroBannerTitleTag   = (!empty($settings['tj_hero_banner_title_tag'])) ? $settings['tj_hero_banner_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "hero-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "hero-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// content
$tjHeroBannerContent   = (!empty($settings['tj_hero_banner_content'])) ? $settings['tj_hero_banner_content'] : "";
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';

if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('tj-content-arg', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('tj-content-arg', 'class', $contentClass);


// Button
$tjHeroButtonShow = !empty($settings['tj_button_show']) ? "yes" : 'no';
$tjHeroBannerBtnText = $settings['tj_hero_banner_btn_text'];
$tjHeroBannerBtnLinkType = $settings['tj_hero_banner_btn_link_type'];
$tjHeroBannerBtnLink = $settings['tj_hero_banner_btn_link'];
$tjHeroBannerBtnPageLink = $settings['tj_hero_banner_btn_page_link'];
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

if (!empty($tjButtonAnimation)) {
  $buttonClass = "tj-primary-btn wow $tjButtonAnimationName";
  $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
} else {
  $buttonClass = "tj-primary-btn";
}

if ('2' == $tjHeroBannerBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjHeroBannerBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
} else {
  if (!empty($tjHeroBannerBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjHeroBannerBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
  }
}

// image
$heroBannerLeftImage   = !empty($settings['tj_hero_banner_left_image']['url']) ? $settings['tj_hero_banner_left_image']['url'] : '';
$heroBannerRightImage   = !empty($settings['tj_hero_banner_right_image']['url']) ? $settings['tj_hero_banner_right_image']['url'] : '';

$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay'] ?? '';
if (!empty($tjImageAnimation)) {
  $imageClass = "hero-image-group wow $tjImageAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjImageAnimationDelay['size'] . "s");
} else {
  $imageClass = "hero-image-group";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

// scroll down
$showScrollDown   = (!empty($settings['tj_scroll_down_show'])) ? $settings['tj_scroll_down_show'] : "";
$scrollDownLink   = (!empty($settings['tj_scroll_down_link'])) ? $settings['tj_scroll_down_link'] : "";

if (!empty($showScrollDown)) {
  $scrollDownClass = "";
} else {
  $scrollDownClass = "no-scrolldown";
}

// shapes
$showBannerShapes   = (!empty($settings['tj_shapes_show'])) ? $settings['tj_shapes_show'] : "";
$bannerShape1   = !empty($settings['tj_hero_banner_shape_1']['url']) ? $settings['tj_hero_banner_shape_1']['url'] : '';
$bannerShape2   = !empty($settings['tj_hero_banner_shape_2']['url']) ? $settings['tj_hero_banner_shape_2']['url'] : '';
$bannerShape3   = !empty($settings['tj_hero_banner_shape_3']['url']) ? $settings['tj_hero_banner_shape_3']['url'] : '';
$bannerShape4   = !empty($settings['tj_hero_banner_shape_4']['url']) ? $settings['tj_hero_banner_shape_4']['url'] : '';
$bannerShape5   = !empty($settings['tj_hero_banner_shape_5']['url']) ? $settings['tj_hero_banner_shape_5']['url'] : '';
$bannerShape6   = !empty($settings['tj_hero_banner_shape_6']['url']) ? $settings['tj_hero_banner_shape_6']['url'] : '';

?>
<!-- start: Hero Area -->
<section class="tj-hero-section heroImage <?php echo esc_attr($scrollDownClass); ?>">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-7">
        <div class="hero-left-content">
          <div class="tj-sec-heading">
            <?php if (!empty($tjHeroBannerSubtitle)) : ?>
              <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
                <?php echo esc_html__($tjHeroBannerSubtitle, 'tjcore'); ?>
              </span>
            <?php endif; ?>

            <?php
            if (!empty($tjHeroBannerTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjHeroBannerTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($tjHeroBannerTitle)
              );
            endif;
            ?>

            <?php if (!empty($tjHeroBannerContent)) : ?>
              <div <?php echo $this->get_render_attribute_string('tj-content-arg'); ?>>
                <p>
                  <?php echo tj_kses($tjHeroBannerContent); ?>
                </p>
              </div>
            <?php endif; ?>

            <?php if ("yes" == $tjHeroButtonShow) : ?>
              <div class="hero-button d-flex">
                <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
                  <?php echo esc_html__($tjHeroBannerBtnText, 'tjcore'); ?>

                  <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                    <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                  <?php endif; ?>
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <div class="col-lg-5">
        <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>

          <?php if (!empty($heroBannerLeftImage)) : ?>
            <div class="group-image1 shake-y">
              <img class="image" src="<?php echo esc_url($heroBannerLeftImage); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_left_image']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          <?php endif; ?>

          <?php if (!empty($heroBannerRightImage)) : ?>
            <div class="group-image2 pulse">
              <img src="<?php echo esc_url($heroBannerRightImage); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_right_image']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          <?php endif; ?>

          <?php if (!empty($showBannerShapes)) : ?>
            <!-- shapes -->
            <?php if (!empty($bannerShape3)) : ?>
              <img class="group-image3" src="<?php echo esc_url($bannerShape3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;

            if (!empty($bannerShape4)) :
            ?>
              <img class="group-image4 pulse" src="<?php echo esc_url($bannerShape4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_4']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;

            if (!empty($bannerShape5)) :
            ?>
              <img class="group-image5 pulse" src="<?php echo esc_url($bannerShape5); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_5']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;

            if (!empty($bannerShape6)) :
            ?>
              <img class="group-image6 pulse" src="<?php echo esc_url($bannerShape6); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_6']['id'], '_wp_attachment_image_alt', true)); ?>" />
          <?php endif;
          endif; ?>

        </div>
      </div>
    </div>
  </div>

  <?php if (!empty($showScrollDown)) : ?>
    <!-- scroll down -->
    <div class="hero-scroll">
      <a class="scroll-icon jump" href="<?php echo esc_attr($scrollDownLink); ?>">
        <?php if (!empty($settings['tj_scroll_down_icon']['value'])) : ?>
          <?php tj_render_icon($settings, 'scroll_down_icon', 'tj_scroll_down_icon'); ?>
        <?php endif; ?>
      </a>
    </div>
  <?php endif; ?>

  <?php if (!empty($showBannerShapes)) : ?>
    <!-- shapes -->
    <?php if (!empty($bannerShape1)) : ?>
      <div class="hero-shape2 pulse">
        <img src="<?php echo esc_url($bannerShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif;

    if (!empty($bannerShape2)) :
    ?>
      <div class="hero-shape3 shake-y">
        <img src="<?php echo esc_url($bannerShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif; ?>

  <?php endif; ?>
</section>
<!-- end: Hero Area -->