<?php
// subtitle
$tjHeroBannerSubtitle   = (!empty($settings['tj_hero_banner_subtitle'])) ? $settings['tj_hero_banner_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "hero-sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "hero-sub-title";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);

// title
$tjHeroBannerTitle   = (!empty($settings['tj_hero_banner_title'])) ? $settings['tj_hero_banner_title'] : "";
$tjHeroBannerTitleTag   = (!empty($settings['tj_hero_banner_title_tag'])) ? $settings['tj_hero_banner_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "hero-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "hero-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// content
$tjHeroBannerContent   = (!empty($settings['tj_hero_banner_content'])) ? $settings['tj_hero_banner_content'] : "";
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';

if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('tj-content-arg', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('tj-content-arg', 'class', $contentClass);


// Button
$tjHeroButtonShow = !empty($settings['tj_button_show']) ? "yes" : 'no';
$tjHeroBannerBtnText = $settings['tj_hero_banner_btn_text'];
$tjHeroBannerBtnLinkType = $settings['tj_hero_banner_btn_link_type'];
$tjHeroBannerBtnLink = $settings['tj_hero_banner_btn_link'];
$tjHeroBannerBtnPageLink = $settings['tj_hero_banner_btn_page_link'];
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

if (!empty($tjButtonAnimation)) {
  $buttonClass = "tj-white-btn-two wow $tjButtonAnimationName";
  $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
} else {
  $buttonClass = "tj-white-btn-two";
}

if ('2' == $tjHeroBannerBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjHeroBannerBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
} else {
  if (!empty($tjHeroBannerBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjHeroBannerBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
  }
}

// image
$heroBannerImage   = !empty($settings['tj_hero_banner_image']['url']) ? $settings['tj_hero_banner_image']['url'] : '';

// shapes
$showBannerShapes   = (!empty($settings['tj_shapes_show'])) ? $settings['tj_shapes_show'] : "";
$bannerShape1   = !empty($settings['tj_hero_banner_shape_1']['url']) ? $settings['tj_hero_banner_shape_1']['url'] : '';
$bannerShape2   = !empty($settings['tj_hero_banner_shape_2']['url']) ? $settings['tj_hero_banner_shape_2']['url'] : '';

// heroBgImage
if (!empty($heroBannerImage)) {
  $bgImage = 'data-bg-image="' . $heroBannerImage . '"';
} else {
  $bgImage = "";
}
?>

<div class="tj-hero-section hero-style-four heroImage" <?php echo esc_attr($bgImage); ?>>
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-12">
        <div class="hero-left-content">
          <div class="tj-sec-heading">

            <?php if (!empty($tjHeroBannerSubtitle)) : ?>
              <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
                <?php echo esc_html__($tjHeroBannerSubtitle, 'tjcore'); ?>
              </span>
            <?php endif; ?>

            <?php
            if (!empty($tjHeroBannerTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjHeroBannerTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($tjHeroBannerTitle)
              );
            endif;
            ?>

            <?php if (!empty($tjHeroBannerContent)) : ?>
              <div <?php echo $this->get_render_attribute_string('tj-content-arg'); ?>>
                <p>
                  <?php echo tj_kses($tjHeroBannerContent); ?>
                </p>
              </div>
            <?php endif; ?>

            <?php if ("yes" == $tjHeroButtonShow) : ?>
              <div class="hero-button d-flex justify-content-center">
                <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
                  <?php echo esc_html__($tjHeroBannerBtnText, 'tjcore'); ?>

                  <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                    <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                  <?php endif; ?>
                </a>
              </div>
            <?php endif; ?>
          </div>
          <div class="hero-circle">
            <span class="circle-1"></span>
            <span class="circle-2"></span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php if (!empty($bannerShape2)) : ?>
    <div class="hero-right-shapes pulse">
      <img src="<?php echo esc_url($bannerShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

  <?php if (!empty($bannerShape1)) : ?>
    <div class="hero-left-shapes pulse">
      <img src="<?php echo esc_url($bannerShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
</div>