<?php
// subtitle
$tjHeroBannerSubtitle   = (!empty($settings['tj_hero_banner_subtitle'])) ? $settings['tj_hero_banner_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);

// title
$tjHeroBannerTitle   = (!empty($settings['tj_hero_banner_title'])) ? $settings['tj_hero_banner_title'] : "";
$tjHeroBannerTitleTag   = (!empty($settings['tj_hero_banner_title_tag'])) ? $settings['tj_hero_banner_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// content
$tjHeroBannerContent   = (!empty($settings['tj_hero_banner_content'])) ? $settings['tj_hero_banner_content'] : "";
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';

if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('tj-content-arg', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('tj-content-arg', 'class', $contentClass);


// Button
$tjHeroButtonShow = !empty($settings['tj_button_show']) ? "yes" : 'no';
$tjHeroBannerBtnText = $settings['tj_hero_banner_btn_text'];
$tjHeroBannerBtnLinkType = $settings['tj_hero_banner_btn_link_type'];
$tjHeroBannerBtnLink = $settings['tj_hero_banner_btn_link'];
$tjHeroBannerBtnPageLink = $settings['tj_hero_banner_btn_page_link'];
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

if (!empty($tjButtonAnimation)) {
  $buttonClass = "btn tj-black-btn-three style-9 wow $tjButtonAnimationName";
  $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
} else {
  $buttonClass = "btn tj-black-btn-three style-9";
}

if ('2' == $tjHeroBannerBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjHeroBannerBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
} else {
  if (!empty($tjHeroBannerBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjHeroBannerBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
  }
}

// image
$heroImage1   = !empty($settings['tj_hero9_image_1']['url']) ? $settings['tj_hero9_image_1']['url'] : '';
$heroImage2   = !empty($settings['tj_hero9_image_2']['url']) ? $settings['tj_hero9_image_2']['url'] : '';
$heroImage3   = !empty($settings['tj_hero9_image_3']['url']) ? $settings['tj_hero9_image_3']['url'] : '';
$heroImage4   = !empty($settings['tj_hero9_image_4']['url']) ? $settings['tj_hero9_image_4']['url'] : '';
$heroImage5   = !empty($settings['tj_hero9_image_5']['url']) ? $settings['tj_hero9_image_5']['url'] : '';
$heroImage6   = !empty($settings['tj_hero9_image_6']['url']) ? $settings['tj_hero9_image_6']['url'] : '';

$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
if (!empty($tjImageAnimation)) {
  $imageClass = "images-item wow $tjImageAnimationName";
} else {
  $imageClass = "images-item";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

// shapes
$bannerShape1   = !empty($settings['tj_hero_banner_shape_1']['url']) ? $settings['tj_hero_banner_shape_1']['url'] : '';

// icons
$bannerIcon1 = !empty($settings['tj_hero_banner_icon_1']['url']) ? $settings['tj_hero_banner_icon_1']['url'] : '';
$bannerIcon2 = !empty($settings['tj_hero_banner_icon_2']['url']) ? $settings['tj_hero_banner_icon_2']['url'] : '';
$bannerIcon3 = !empty($settings['tj_hero_banner_icon_3']['url']) ? $settings['tj_hero_banner_icon_3']['url'] : '';
$bannerIcon4 = !empty($settings['tj_hero_banner_icon_4']['url']) ? $settings['tj_hero_banner_icon_4']['url'] : '';
?>

<!-- start: Hero Section -->
<section class="tj-hero-section style-9">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-12">
        <div class="hero-left-content style-9">
          <div class="tj-sec-heading style-9">

            <?php if (!empty($tjHeroBannerSubtitle)) : ?>
              <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
                <?php echo esc_html__($tjHeroBannerSubtitle, 'tjcore'); ?>
              </span>
            <?php endif; ?>

            <?php
            if (!empty($tjHeroBannerTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjHeroBannerTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($tjHeroBannerTitle)
              );
            endif;
            ?>
            <?php if (!empty($tjHeroBannerContent)) : ?>
              <div <?php echo $this->get_render_attribute_string('tj-content-arg'); ?>>
                <p>
                  <?php echo tj_kses($tjHeroBannerContent); ?>
                </p>
              </div>
            <?php endif; ?>


            <?php if ("yes" == $tjHeroButtonShow) : ?>
              <div class="hero-button d-flex justify-content-center">
                <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
                  <?php echo esc_html__($tjHeroBannerBtnText, 'tjcore'); ?>

                  <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                    <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                  <?php endif; ?>
                </a>
              </div>
            <?php endif; ?>

          </div>
          <div class="hero-circle">
            <span class="circle-1"></span>
            <span class="circle-2"></span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php if (!empty($heroImage1 || $heroImage2 || $heroImage3 || $heroImage4 || $heroImage5 || $heroImage6)) : ?>
    <div class="container-fluid">
      <div class="hero-wrapper-9">
        <?php if (!empty($heroImage1)) : ?>
          <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> data-wow-delay=".3s">
            <div class="hero9-images">
              <img src="<?php echo esc_url($heroImage1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero9_image_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        <?php endif;

        if (!empty($heroImage2)) : ?>
          <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> data-wow-delay=".4s">

            <?php if (!empty($bannerShape1)) : ?>
              <div class="hero-shaes d-none d-md-inline-flex">
                <img src="<?php echo esc_url($bannerShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php endif; ?>

            <div class="hero9-images">
              <img src="<?php echo esc_url($heroImage2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero9_image_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        <?php endif;

        if (!empty($heroImage3)) : ?>
          <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> data-wow-delay=".5s">
            <div class="hero9-images">
              <img src="<?php echo esc_url($heroImage3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero9_image_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        <?php endif;

        if (!empty($heroImage4)) : ?>
          <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> data-wow-delay=".6s">
            <div class="hero9-images">
              <img src="<?php echo esc_url($heroImage4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero9_image_4']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        <?php endif;

        if (!empty($heroImage5)) : ?>
          <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> data-wow-delay=".7s">
            <div class="hero9-images">
              <img src="<?php echo esc_url($heroImage5); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero9_image_5']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
            <?php if (!empty($bannerShape1)) : ?>
              <div class="hero-shaes d-none d-md-inline-flex">
                <img src="<?php echo esc_url($bannerShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php endif; ?>

          </div>
        <?php endif;

        if (!empty($heroImage6)) : ?>
          <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> data-wow-delay=".9s">
            <div class="hero9-images">
              <img src="<?php echo esc_url($heroImage6); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero9_image_6']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($bannerIcon1)) : ?>
    <div class="hero-icon-1 wow zoomIn" data-wow-delay=".3s">
      <img src="<?php echo esc_url($bannerIcon1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_icon_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif;

  if (!empty($bannerIcon2)) :  ?>
    <div class="hero-icon-2 wow zoomIn" data-wow-delay=".4s">
      <img src="<?php echo esc_url($bannerIcon2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_icon_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif;

  if (!empty($bannerIcon3)) :  ?>
    <div class="hero-icon-3 wow zoomIn" data-wow-delay=".5s">
      <img src="<?php echo esc_url($bannerIcon3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_icon_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif;

  if (!empty($bannerIcon4)) :  ?>
    <div class="hero-icon-4 wow zoomIn" data-wow-delay=".6s">
      <img src="<?php echo esc_url($bannerIcon4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_hero_banner_icon_4']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
</section>
<!-- end: Hero Section -->