<?php
$slider_list = (isset($settings['slider_list']) && !empty($settings['slider_list'])) ? $settings['slider_list'] : [];

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');
$dots            = (isset($settings['slide_dot']) && !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no');

$sliderShape            =  !empty($settings['tj_slider_shape']) ? $settings['tj_slider_shape'] : '';
?>


<?php if (!empty($slider_list)) : ?>
  <section class="tj-slider-section heroSliderWrap" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>" data-loop="<?php echo $loop; ?>" data-dots="<?php echo $dots; ?>">
    <div class="swiper tj-hero-slider" id="hero-slider-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($slider_list as $slider) :

          $this->add_render_attribute('title_args', 'class', 'title');
          $sliderImage   = (isset($slider['tj_slider_img']['url']) && $slider['tj_slider_img']['url'] != '') ? $slider['tj_slider_img']['url'] : '';

          $subtitle = !empty($slider['tj_slider_sub_title']) ? $slider['tj_slider_sub_title'] : '';
          $title    = !empty($slider['tj_slider_title']) ? $slider['tj_slider_title'] : '';
          $desc = !empty($slider['tj_slider_desc']) ? $slider['tj_slider_desc'] : '';

          $tj_buttons_switcher = (isset($slider['tj_button_switcher']) ? $slider['tj_button_switcher'] : false);
          $tj_btn_text = (isset($slider['tj_btn_text']) ? $slider['tj_btn_text'] : '');

          // btn Link
          if ('2' == $slider['tj_btn_link_type']) {
            $link = get_permalink($slider['tj_btn_page_link']);
            $target = '_self';
            $rel = 'nofollow';
          } else {
            $link = !empty($slider['tj_btn_link']['url']) ? $slider['tj_btn_link']['url'] : '';
            $target = !empty($slider['tj_btn_link']['is_external']) ? '_blank' : '';
            $rel = !empty($slider['tj_btn_link']['nofollow']) ? 'nofollow' : '';
          }

          // sliderBgImage
          if (!empty($sliderImage)) {
            $bgImage = 'data-bg-image="' . $sliderImage . '"';
          } else {
            $bgImage = "";
          }
        ?>
          <div class="swiper-slide ">

            <div class="slider_bg sliderImage" <?php echo esc_attr($bgImage); ?>></div>

            <div class="container">
              <div class="hero-content-area">
                <div class="tj-sec-heading">

                  <?php if (!empty($subtitle)) : ?>
                    <span class="white-sub-title">
                      <div><?php echo tj_kses($subtitle); ?></div>
                    </span>
                  <?php endif; ?>

                  <?php
                  if (!empty($title)) :
                    printf(
                      '<%1$s %2$s><div>%3$s</div></%1$s>',
                      tag_escape($slider['tj_slider_title_tag']),
                      $this->get_render_attribute_string('title_args'),
                      tj_kses($title)
                    );
                  endif;
                  ?>

                  <?php if (!empty($desc)) : ?>
                    <div class="desc">
                      <div>
                        <p><?php echo tj_kses($desc); ?></p>
                      </div>
                    </div>
                  <?php endif; ?>

                  <?php if (!empty($tj_buttons_switcher || $tj_btn_text)) : ?>
                    <div class="hero-button d-flex">
                      <a class="btn tj-primary-btn" href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>"><?php echo esc_html__($tj_btn_text, 'tjcore'); ?></a>
                    </div>
                  <?php endif; ?>

                </div>
              </div>
            </div>
            <div class="hero-group-shape">
              <div class="hero-shape"></div>

              <?php if (!empty($sliderShape['url'])) : ?>
                <div class="slider_shape">
                  <img src="<?php echo esc_url($sliderShape['url']); ?>" alt="<?php echo esc_attr(get_post_meta($sliderShape['id'], '_wp_attachment_image_alt', true)); ?>">
                </div>
              <?php endif; ?>

            </div>
          </div>
        <?php endforeach; ?>

      </div>
      <?php if ($dots == 'yes') : ?>
        <div class="swiper-pagination"></div>
      <?php endif; ?>
    </div>
  </section>
<?php endif; ?>