<?php
$iconBoxTitle   = (!empty($settings['tj_iconbox_title'])) ? $settings['tj_iconbox_title'] : '';
$iconBoxLabel   = (!empty($settings['tj_list_item_title'])) ? $settings['tj_list_item_title'] : '';
$iconBoxLink   = (!empty($settings['tj_list_item_link'])) ? $settings['tj_list_item_link'] : '';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $itemClass = "sidebar-contact wow $tjAnimationName";
  $this->add_render_attribute('tj-item-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $itemClass = "sidebar-contact";
}
$this->add_render_attribute('tj-item-arg', 'class', $itemClass);
?>

<aside <?php echo $this->get_render_attribute_string('tj-item-arg'); ?>>
  <div class="contact-icon">
    <?php tj_render_icon($settings, 'tj_icon', 'tj_iconbox_icon'); ?>
  </div>
  <div class="contact-link">
    <?php if (!empty($iconBoxLink)) : ?>
      <a href="<?php echo esc_attr($iconBoxLink); ?>"><?php echo esc_html($iconBoxLabel); ?></a>
    <?php else : ?>
      <p><?php echo tj_kses($iconBoxLabel); ?></p>
    <?php endif; ?>
  </div>

  <?php if (!empty($iconBoxTitle)) : ?>
    <span><?php echo tj_kses($iconBoxTitle); ?></span>
  <?php endif; ?>

</aside>