<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

// include_posts
$post__in = '';
if (!empty($settings['post__in'])) {
  $post__not_in = $settings['post__in'];
  $args['post__in'] = $post__in;
}

// exclude_posts
$post__not_in = '';
if (!empty($settings['post__not_in'])) {
  $post__not_in = $settings['post__not_in'];
  $args['post__not_in'] = $post__not_in;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';
$ignore_sticky_posts = (!empty($settings['ignore_sticky_posts']) && 'yes' == $settings['ignore_sticky_posts']) ? true : false;

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
  'ignore_sticky_posts' => $ignore_sticky_posts
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'category',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'category',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'category',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}

// The Query
$query = new \WP_Query($args);


$tjAnimation = !empty($settings['tj_animation']) ? $settings['tj_animation'] : "";
if (!empty($tjAnimation)) {
  $blogClass = "tj-blog-item-three wow fadeInUp";
  $this->add_render_attribute('tj-blog-arg', 'data-wow-delay', "0.3s");
} else {
  $blogClass = "tj-blog-item-three";
}
$this->add_render_attribute('tj-blog-arg', 'class', $blogClass);
?>

<div class="tj-blog-section-three">
  <?php if ($query->have_posts()) : ?>
    <div class="row">
      <?php
      $n = 0;
      while ($query->have_posts()) :
        $n++;
        $query->the_post();

        $categories = get_the_terms(get_the_ID(), 'category');
      ?>
        <div class="col-lg-4 col-md-6">
          <div <?php echo $this->get_render_attribute_string('tj-blog-arg'); ?>>

            <?php if (has_post_thumbnail()) : ?>
              <div class="blog-image">
                <a href="<?php the_permalink(); ?>">
                  <?php the_post_thumbnail('blog_thumb_1'); ?>
                </a>
              </div>
            <?php endif; ?>

            <div class="blog-content-area">
              <div class="blog-meta-three">
                <?php if (!empty($categories[0]->name)) : ?>
                  <span><a class="category" href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a></span>
                <?php endif; ?>

                <span><?php the_time('M j, Y'); ?></span>
              </div>
              <h4 class="title-link">
                <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?></a>
              </h4>
              <?php if (!empty($settings['tj_post_button'])) : ?>
                <div class="tj-blog-button">
                  <a href="<?php the_permalink(); ?>" class="btn tj-white-btn"><?php echo esc_html__($settings['tj_post_button_text'], 'tjcore'); ?></a>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endwhile;
      wp_reset_query(); ?>
    </div>
  <?php else :
    printf("No post available!");
  endif; ?>
</div>