<?php

$tj_title = $settings['tj_title'];
$tj_header_navigation = (!empty($settings['tj_header_navigation'])) ? $settings['tj_header_navigation'] : "";

$headerTitle = $tj_title ? $tj_title : get_the_title(get_the_ID());

$bg_img   = !empty($settings['tj_image']['url']) ? $settings['tj_image']['url'] : '';


// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $titleClass = "breadcrumb-title wow $tjAnimationName";
  $animationDelay = $tjAnimationDelay['size'];
} else {
  $titleClass = "breadcrumb-title";
  $animationDelay = '';
}

$this->add_render_attribute('title_args', 'class', $titleClass);
$this->add_render_attribute('title_args', 'data-wow-delay', $animationDelay);

// Breadcrumb bg image
if (!empty($bg_img)) {
  $bgImage = 'data-bg-image="' . $bg_img . '"';
} else {
  $bgImage = "";
}

// shapes
$breadcrumbShapes = !empty($settings['tj_breadcrumb_shapes']) ? $settings['tj_breadcrumb_shapes'] : "";
$shapeImg1 = !empty($settings['tj_shape_1']['url']) ? $settings['tj_shape_1']['url'] : "";
$shapeImg2 = !empty($settings['tj_shape_2']['url']) ? $settings['tj_shape_2']['url'] : "";
$shapeImg3 = !empty($settings['tj_shape_3']['url']) ? $settings['tj_shape_3']['url'] : "";
$shapeImg4 = !empty($settings['tj_shape_4']['url']) ? $settings['tj_shape_4']['url'] : "";
$shapeImg5 = !empty($settings['tj_shape_5']['url']) ? $settings['tj_shape_5']['url'] : "";
$shapeImg6 = !empty($settings['tj_shape_6']['url']) ? $settings['tj_shape_6']['url'] : "";
$shapeImg7 = !empty($settings['tj_shape_7']['url']) ? $settings['tj_shape_7']['url'] : "";
$shapeImg8 = !empty($settings['tj_shape_8']['url']) ? $settings['tj_shape_8']['url'] : "";
?>



<div class="breadcrumb-wrapper" <?php echo esc_attr($bgImage); ?>>
  <div class="container">
    <div class="row">
      <div class="col">
        <div class="breadcrumb-content-area">
          <?php if (!empty($headerTitle)) : ?>
            <div class="breadcrumb-heading">
              <?php printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['tj_title_tag']),
                $this->get_render_attribute_string('title_args'),
                tj_kses($headerTitle)
              ); ?>
            </div>
          <?php endif; ?>

          <?php if (!empty($tj_header_navigation)) : ?>
            <div class="breadcrumb-link wow fadeInUp" data-wow-delay=".5s">
              <?php bcn_display(); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <?php if (!empty($breadcrumbShapes)) : ?>
    <div class="tj-breadcrumb-shape">
      <?php if (!empty($shapeImg1)) : ?>
        <div class="breadcrumb-shape-3 pulse">
          <img src="<?php echo esc_url($shapeImg1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg2)) : ?>
        <div class="breadcrumb-shape-2 shake-y">
          <img src="<?php echo esc_url($shapeImg2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg3)) : ?>
        <div class="breadcrumb-shape-5 pulse">
          <img src="<?php echo esc_url($shapeImg3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg4)) : ?>
        <div class="breadcrumb-shape-4 shake-y">
          <img src="<?php echo esc_url($shapeImg4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_4']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg5)) : ?>
        <div class="breadcrumb-shape-1 pulse">
          <img src="<?php echo esc_url($shapeImg5); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_5']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg6)) : ?>
        <div class="breadcrumb-shape-6 pulse">
          <img src="<?php echo esc_url($shapeImg6); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_6']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg7)) : ?>
        <div class="breadcrumb-shape-7 shake-y">
          <img src="<?php echo esc_url($shapeImg7); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_7']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>

      <?php if (!empty($shapeImg8)) : ?>
        <div class="breadcrumb-shape-8 pulse">
          <img src="<?php echo esc_url($shapeImg8); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_8']['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>