<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'portfolios',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'portfolios-cat',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'portfolios-cat',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'portfolios-cat',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}


// The Query
$query = new \WP_Query($args);


$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$dot            = (isset($settings['slide_dot']) && !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $portfolioClass = "tj-portfolios style-6 carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-portfolio-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $portfolioClass = "tj-portfolios style-6 carouselWrap";
}
$this->add_render_attribute('tj-portfolio-arg', 'class', $portfolioClass);
?>

<section <?php echo $this->get_render_attribute_string('tj-portfolio-arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if ($query->have_posts()) : ?>
    <div class="row">
      <div class="col">
        <div class="portfolio_carousel style-6 swiper swiper-container" id="portCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">

            <?php while ($query->have_posts()) : $query->the_post();

              // post category echo 
              $portfolio_cats = get_the_terms(get_the_ID(), 'portfolios-cat');
            ?>
              <div class="swiper-slide">
                <div class="portfolio_item">

                  <?php if (!empty(has_post_thumbnail())) : ?>
                    <div class="portfolio_image">
                      <?php the_post_thumbnail('portfolio_thumb_2'); ?>
                    </div>
                  <?php endif; ?>

                  <div class="portfolio_content">
                    <div class="content_text">
                      <?php if (!empty($portfolio_cats[0]->name)) : ?>
                        <span class="category"><a href="<?php echo esc_url(get_category_link($portfolio_cats[0]->term_id)); ?>"><?php echo esc_html($portfolio_cats[0]->name); ?></a></span>
                      <?php endif; ?>

                      <h4 class="title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                      </h4>
                    </div>
                    <a class="arrow_btn" href="<?php the_permalink(); ?>"><i class="flaticon-next"></i></a>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_query(); ?>

          </div>

          <?php if ("yes" == $settings['slide_dot']) : ?>
            <div class="portfolio_pagination"></div>
          <?php endif; ?>

        </div>
      </div>
    </div>
  <?php else :
    printf("%s", esc_html__("No portfolios available", 'tjcore'));
  endif; ?>
</section>