<?php
$portfolioInfoTitle   = (!empty($settings['tj_portfolio_info_title'])) ? $settings['tj_portfolio_info_title'] : '';
$portfolioTitleTag   = (!empty($settings['tj_title_tag'])) ? $settings['tj_title_tag'] : "";
$this->add_render_attribute('title_args', 'class', "portfolio-info-title");

$portfolioInfoList   = (!empty($settings['tj_info_list'])) ? $settings['tj_info_list'] : '';
$showPortfolioSocials   = (!empty($settings['show_portfolio_socials'])) ? $settings['show_portfolio_socials'] : '';
$portfolioSocials   = (!empty($settings['tj_socials_list'])) ? $settings['tj_socials_list'] : '';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $itemClass = "portfolio-info wow $tjAnimationName";
  $this->add_render_attribute('tj-portfolio-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $itemClass = "portfolio-info";
}
$this->add_render_attribute('tj-portfolio-arg', 'class', $itemClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-portfolio-arg'); ?>>

  <?php
  if (!empty($portfolioInfoTitle)) :
    printf(
      '<%1$s %2$s>%3$s</%1$s>',
      tag_escape($portfolioTitleTag),
      $this->get_render_attribute_string('title_args'),
      tj_kses($portfolioInfoTitle)
    );
  endif;
  ?>

  <?php if (!empty($portfolioInfoList)) :

    foreach ($portfolioInfoList as $info) :
  ?>
      <div class="info-item">
        <?php if (!empty($info['tj_info_label'])) : ?>
          <h5 class="title"><?php echo esc_html__($info['tj_info_label'], 'tjcore'); ?></h5>
        <?php endif;

        if (!empty($info['tj_info_desc'])) : ?>
          <span class="info"><?php echo tj_kses($info['tj_info_desc']); ?></span>
        <?php endif; ?>
      </div>
  <?php endforeach;
  endif; ?>

  <?php if (!empty($showPortfolioSocials && $portfolioSocials)) : ?>
    <div class="portfolio-socials">
      <ul class="dot-style">
        <?php foreach ($portfolioSocials as $social) :

          $link = !empty($social['tj_social_link']['url']) ? $social['tj_social_link']['url'] : '';
          $target = !empty($social['tj_social_link']['is_external']) ? '_blank' : '';
          $rel = !empty($social['tj_social_link']['nofollow']) ? 'nofollow' : '';
        ?>
          <li>
            <?php if (!empty($link)) :
              $href = 'href=' . $link . '';
              if (!empty($target)) :
                $target = 'target=' . $target . '';
              endif;
              if (!empty($rel)) :
                $rel = 'rel=' . $rel . '';
              endif;
            ?>
              <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                <?php tj_render_icon($social, 'tj_social_icon', 'tj_icon'); ?>
              </a>
            <?php else :
              tj_render_icon($social, 'tj_social_icon', 'tj_icon');
            endif;
            ?>
          </li>
        <?php endforeach; ?>

      </ul>
    </div>
  <?php endif; ?>
</div>