<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'portfolios',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'portfolios-cat',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'portfolios-cat',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'portfolios-cat',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}


// The Query
$query = new \WP_Query($args);

$categoryFilter = !empty($settings['category_filter']) ? $settings['category_filter'] : "show";

$portfolioCategories = get_terms('portfolios-cat', array('hide_empty' => true));
?>

<div class="tj_portfolios">
  <?php if ($query->have_posts()) : ?>
    <div class="row">
      <?php while ($query->have_posts()) : $query->the_post();

        // post category echo 
        $portfolio_cats = get_the_terms(get_the_ID(), 'portfolios-cat');
      ?>
        <div class="col-xl-4 col-md-6">
          <div class="tj-portfolio-item-two wow fadeInUp" data-wow-delay="0.3s">

            <?php if (!empty(has_post_thumbnail())) : ?>
              <div class="portfolio-image">
                <?php the_post_thumbnail('portfolio_thumb'); ?>
              </div>
            <?php endif; ?>

            <div class="portfolio-content">
              <?php if (!empty($portfolio_cats[0]->name)) : ?>
                <span class="sub-title"><a href="<?php echo esc_url(get_category_link($portfolio_cats[0]->term_id)); ?>"><?php echo esc_html($portfolio_cats[0]->name); ?></a></span>
              <?php endif; ?>

              <h4 class="title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
              </h4>
            </div>
          </div>
        </div>
      <?php endwhile;
      wp_reset_query(); ?>

    </div>
  <?php else :
    printf("%s", esc_html__("No portfolios available", 'tjcore'));
  endif; ?>
</div>