<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'portfolios',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'portfolios-cat',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'portfolios-cat',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'portfolios-cat',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}


// The Query
$query = new \WP_Query($args);

// portfolio Filter
$categoryFilter = !empty($settings['category_filter']) ? $settings['category_filter'] : "show";
$portfolioCategories = get_terms('portfolios-cat', array('hide_empty' => true));

// filter animation
$tjFilterAnimation   = $settings['tj_filter_animation'] ?? '';
$tjFilterAnimationName   = $settings['tj_filter_animation_name'] ?? '';
$tjFilterAnimationDelay   = $settings['tj_filter_animation_delay'] ?? '';

if (!empty($tjFilterAnimation)) {
  $portfolioFilterClass = "tj-portfolio-filter style-3 wow $tjFilterAnimationName";
  $this->add_render_attribute('tj-portfolio-filter-arg', 'data-wow-delay', $tjFilterAnimationDelay['size'] . "s");
} else {
  $portfolioFilterClass = "tj-portfolio-filter style-3";
}
$this->add_render_attribute('tj-portfolio-filter-arg', 'class', $portfolioFilterClass);
?>

<div class="tj_portfolios style-8">

  <?php if ('show' == $categoryFilter) : ?>
    <div <?php echo $this->get_render_attribute_string('tj-portfolio-filter-arg'); ?>>
      <div class="row">
        <div class="col">
          <div class="filter-menu">
            <button class="filter active" data-filter="*"><?php esc_html_e('All', 'tjcore'); ?></button>

            <?php foreach ($portfolioCategories as $cat) : ?>
              <button class="filter" data-filter=".<?php echo esc_attr($cat->slug); ?>"><?php echo esc_html__($cat->name, 'tjcore'); ?></button>
            <?php endforeach; ?>

          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php if ($query->have_posts()) : ?>

    <div class="portfolio-items-area wow fadeInUp" data-wow-delay=".3s">
      <div class="row">
        <div class="col-md-12 portfolio-content">
          <div class="portfolio-gallery masonary">
            <div id="portfolio-grid" class="portfolio-items colums-3">

              <?php
              while ($query->have_posts()) : $query->the_post();

                $portfolioCats = get_the_terms(get_the_ID(), 'portfolios-cat');
                $cats = [];
                if (!empty($portfolioCats)) :
                  foreach ($portfolioCats as $cat) {
                    $cats[] = $cat->slug;
                  }
                endif;

                $catsN = [];
                if (!empty($portfolioCats)) :
                  foreach ($portfolioCats as $cat) {
                    $catsN[] = $cat->name;
                  }
                endif; ?>
                <div class="portfolio-single-item <?php echo esc_attr(implode(" ", $cats)); ?>">
                  <div class="portfolio-single">
                    <?php if (!empty(has_post_thumbnail())) : ?>
                      <div class="portfolio-image">
                        <?php the_post_thumbnail('full'); ?>
                      </div>
                    <?php endif; ?>

                    <div class="portfolio-content">
                      <h3 class="title-link">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                      </h3>
                      <span class="sub-title"><?php echo esc_attr(implode("/", $catsN)); ?></span>
                    </div>
                  </div>
                </div>
              <?php endwhile;
              wp_reset_query(); ?>
            </div>
          </div>
        </div>
      </div>
    </div>

  <?php else :
    printf("%s", esc_html__("No portfolios available", 'tjcore'));
  endif; ?>
</div>