<?php
$price_title = !empty($settings['price_title']) ? $settings['price_title'] : "";
$price_currency = !empty($settings['price_currency']) ? $settings['price_currency'] : "";
$price_price = !empty($settings['price_price']) ? $settings['price_price'] : "";

$recommended = !empty($settings['is_price_box_recommend']) ? 'price-active' : '';

$price_features_list = !empty($settings['price_features_list']) ? $settings['price_features_list'] : "";

if ($price_currency === 'custom') {
  $currency = $settings['currency_custom'];
} else {
  $currency = self::get_currency_symbol($price_currency);
}


$tj_btn_text = !empty($settings['tj_btn_text']) ? $settings['tj_btn_text'] : "";
$tj_btn_link_type = !empty($settings['tj_btn_link_type']) ? $settings['tj_btn_link_type'] : "";
$tj_btn_link = !empty($settings['tj_btn_link']) ? $settings['tj_btn_link'] : "";
$tj_btn_page_link = !empty($settings['tj_btn_page_link']) ? $settings['tj_btn_page_link'] : "";


if ('2' == $tj_btn_link_type) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tj_btn_page_link));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', 'btn tj-black-btn');
} else {
  if (!empty($tj_btn_link['url'])) {
    $this->add_link_attributes('tj-button-arg', $tj_btn_link);
    $this->add_render_attribute('tj-button-arg', 'class', 'btn tj-black-btn');
  }
}

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $priceBoxClass = "tj-price-item $recommended wow $tjAnimationName";
  $this->add_render_attribute('tj-price-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $priceBoxClass = "tj-price-item $recommended";
}
$this->add_render_attribute('tj-price-arg', 'class', $priceBoxClass);
?>


<div <?php echo $this->get_render_attribute_string('tj-price-arg'); ?>>
  <div class="tj-price-content-area">
    <div class="price-top-content">

      <div class="price-icon">
        <?php tj_render_icon($settings, 'price_icon', 'price_box_icon'); ?>
      </div>

      <div class="price-text">
        <?php if ($price_title) : ?>
          <h3 class="title"><?php echo esc_html__($price_title, 'tjcore'); ?></h3>
        <?php endif; ?>
        <?php if ($price_price) : ?>
          <span class="price"><?php echo esc_html($currency); ?><?php echo esc_html($price_price); ?></span>
        <?php endif; ?>
      </div>
    </div>
    <div class="price-bottom-content">

      <?php if (!empty($price_features_list)) : ?>
        <div class="price-list">
          <ul class="dot-style">
            <?php foreach ($price_features_list as $key => $item) :
              $availability = !empty($item['price_feature_unavailable']) ? 'hide' : 'active';
            ?>
              <li class="<?php echo esc_attr($availability); ?>"><?php tj_render_icon($item, 'tj_features_icon', 'tj_features_selected_icon'); ?> <?php echo tj_kses($item['price_feature_text']); ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <?php if (!empty($tj_btn_text)) : ?>
        <div class="price-button d-flex">
          <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>><?php echo esc_html__($tj_btn_text, 'tjcore'); ?></a>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>