<?php
$progressTitle   = (!empty($settings['tj_progress_title'])) ? $settings['tj_progress_title'] : '';
$progressDesc   = (!empty($settings['tj_progress_desc'])) ? $settings['tj_progress_desc'] : '';
$progressBar   = (!empty($settings['tj_progress_bar'])) ? $settings['tj_progress_bar'] : '';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $progressClass = "tj-product-item wow $tjAnimationName";
  $this->add_render_attribute('tj-item-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $progressClass = "tj-product-item";
}
$this->add_render_attribute('tj-item-arg', 'class', $progressClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-item-arg'); ?>>
  <div class="product-icon">
    <?php tj_render_icon($settings, 'tj_icon', 'tj_progress_icon'); ?>
  </div>
  <div class="product-content">

    <?php if (!empty($progressTitle)) : ?>
      <h4 class="title"><?php echo esc_html__($progressTitle, 'tjcore'); ?></h4>
    <?php endif; ?>

    <?php if (!empty($progressDesc)) : ?>
      <p><?php echo esc_html__($progressDesc, 'tjcore'); ?></p>
    <?php endif; ?>

    <?php if (!empty($progressBar)) : ?>
      <div class="tj-progress-bar">
        <div class="skills" data-percent="<?php echo esc_attr($progressBar['size'] . $progressBar['unit']); ?>">
          <span><?php echo esc_html($progressBar['size'] . $progressBar['unit']); ?></span>
          <div class="skillbar"></div>
        </div>
      </div>
    <?php endif; ?>

  </div>
</div>