<?php
// subtitle
$tjSectionSubtitle   = (!empty($settings['tj_subtitle'])) ? $settings['tj_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = (!empty($settings['tj_title'])) ? $settings['tj_title'] : "";
$tjSectionTitleTag   = (!empty($settings['tj_title_tag'])) ? $settings['tj_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "sec-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// content
$tjShowContent   = (!empty($settings['is_content'])) ? "yes" : "no";
$tjSectionContent   = (!empty($settings['tj_content'])) ? $settings['tj_content'] : "";
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';

if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('tj-content-arg', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('tj-content-arg', 'class', $contentClass);

// button
$tjButtonSwitcher   = (isset($settings['tj_btn_button_show']) ? $settings['tj_btn_button_show'] : '');
$tjButtonText   = (isset($settings['tj_btn_text']) ? $settings['tj_btn_text'] : '');
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

if (!empty($tjButtonAnimation)) {
  $buttonClass = "tj-secondary-btn btn-border wow $tjButtonAnimationName";
  $buttonAnimationDelay = $tjButtonAnimationDelay['size'];
} else {
  $buttonClass = "tj-secondary-btn btn-border";
  $buttonAnimationDelay = '';
}

// Link
if ('2' == $settings['tj_btn_link_type']) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($settings['tj_btn_page_link']));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
  $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $buttonAnimationDelay . "s");
} else {
  if (!empty($settings['tj_btn_link']['url'])) {
    $this->add_link_attributes('tj-button-arg', $settings['tj_btn_link']);
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
    $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $buttonAnimationDelay . "s");
  }
}
?>

<div class="tj-sec-heading">
  <?php if (!empty($tjSectionSubtitle)) : ?>
    <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
      <?php echo esc_html__($tjSectionSubtitle, "tjcore"); ?>
    </span>
  <?php endif; ?>

  <?php
  if (!empty($tjSectionTitle)) :
    printf(
      '<%1$s %2$s>%3$s</%1$s>',
      tag_escape($tjSectionTitleTag),
      $this->get_render_attribute_string('title_args'),
      tj_kses($tjSectionTitle)
    );
  endif;
  ?>
  <?php if (!empty($tjSectionContent)) : ?>
    <div <?php echo $this->get_render_attribute_string('tj-content-arg'); ?>>
      <?php echo tj_kses($tjSectionContent); ?>
    </div>
  <?php endif; ?>


  <?php if (!empty($tjButtonSwitcher && $tjButtonText)) : ?>
    <div class="sec-button">
      <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
        <span>
          <?php echo esc_html__($tjButtonText, 'tjcore'); ?>

          <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
            <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
          <?php endif; ?>
        </span>
      </a>
    </div>
  <?php endif; ?>
</div>