<?php
// subtitle
$tjSectionSubtitle   = (!empty($settings['tj_subtitle'])) ? $settings['tj_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = (!empty($settings['tj_title'])) ? $settings['tj_title'] : "";
$tjSectionTitleTag   = (!empty($settings['tj_title_tag'])) ? $settings['tj_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "sec-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// content
$tjShowContent   = (!empty($settings['is_content'])) ? "yes" : "no";
$tjSectionContent   = (!empty($settings['tj_content'])) ? $settings['tj_content'] : "";
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';

if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('tj-content-arg', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('tj-content-arg', 'class', $contentClass);

// button
$tjButtonSwitcher   = (isset($settings['tj_btn_button_show']) ? $settings['tj_btn_button_show'] : '');
$tjButtonText   = (isset($settings['tj_btn_text']) ? $settings['tj_btn_text'] : '');
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

if (!empty($tjButtonAnimation)) {
  $buttonClass = "tj-secondary-btn btn-border wow $tjButtonAnimationName";
  $buttonAnimationDelay = $tjButtonAnimationDelay['size'];
} else {
  $buttonClass = "tj-secondary-btn btn-border";
  $buttonAnimationDelay = '';
}

// Link
if ('2' == $settings['tj_btn_link_type']) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($settings['tj_btn_page_link']));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
  $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $buttonAnimationDelay . "s");
} else {
  if (!empty($settings['tj_btn_link']['url'])) {
    $this->add_link_attributes('tj-button-arg', $settings['tj_btn_link']);
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
    $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $buttonAnimationDelay . "s");
  }
}

// images
$tjImagesShow = !empty($settings['tj_sec_images_show']) ? $settings['tj_sec_images_show'] : '';
$tjImagesStyle = !empty($settings['tj_section_image_style']) ? $settings['tj_section_image_style'] : '1';
$sectionImage1 = !empty($settings['tj_sec_image-1']['url']) ? $settings['tj_sec_image-1']['url'] : '';
$sectionImage2 = !empty($settings['tj_sec_image-2']['url']) ? $settings['tj_sec_image-2']['url'] : '';
$sectionImage3 = !empty($settings['tj_sec_image-3']['url']) ? $settings['tj_sec_image-3']['url'] : '';
$sectionImage4 = !empty($settings['tj_sec_image-4']['url']) ? $settings['tj_sec_image-4']['url'] : '';
// shapes
$sectionShape1 = !empty($settings['tj_sec_shape-1']['url']) ? $settings['tj_sec_shape-1']['url'] : '';
$sectionShape2 = !empty($settings['tj_sec_shape-2']['url']) ? $settings['tj_sec_shape-2']['url'] : '';
$sectionShape3 = !empty($settings['tj_sec_shape-3']['url']) ? $settings['tj_sec_shape-3']['url'] : '';
$sectionShape4 = !empty($settings['tj_sec_shape-4']['url']) ? $settings['tj_sec_shape-4']['url'] : '';

$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay'] ?? '';

if (!empty($tjImageAnimation)) {
  $imageClass = "tj_sec_images wow $tjImageAnimationName";
  $imageAnimationDelay = $tjImageAnimationDelay['size'];
} else {
  $imageClass = "tj_sec_images";
  $imageAnimationDelay = '';
}
$this->add_render_attribute('tj-images-arg', 'class', $imageClass);
?>

<div class="tj-sec-heading">
  <?php if (!empty($tjSectionSubtitle)) : ?>
    <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
      <?php echo esc_html__($tjSectionSubtitle, "tjcore"); ?>
    </span>
  <?php endif; ?>

  <?php
  if (!empty($tjSectionTitle)) :
    printf(
      '<%1$s %2$s>%3$s</%1$s>',
      tag_escape($tjSectionTitleTag),
      $this->get_render_attribute_string('title_args'),
      tj_kses($tjSectionTitle)
    );
  endif;
  ?>
  <?php if (!empty($tjSectionContent)) : ?>
    <div <?php echo $this->get_render_attribute_string('tj-content-arg'); ?>>
      <?php echo tj_kses($tjSectionContent); ?>
    </div>
  <?php endif; ?>


  <?php if (!empty($tjButtonSwitcher && $tjButtonText)) : ?>
    <div class="sec-button">
      <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
        <span>
          <?php echo esc_html__($tjButtonText, 'tjcore'); ?>

          <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
            <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
          <?php endif; ?>
        </span>
      </a>
    </div>
  <?php endif; ?>
</div>

<?php if ("yes" == $tjImagesShow) : ?>
  <div <?php echo $this->get_render_attribute_string('tj-images-arg'); ?>>

    <?php if ("3" == $tjImagesStyle) : ?>
      <div class="sec-image-group-3">

        <?php if (!empty($sectionImage1)) :  ?>
          <div class="group-image">
            <img src="<?php echo esc_url($sectionImage1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-1']['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>

        <?php if (!empty($sectionShape2)) :  ?>
          <img class="shape-2 shake-y" src="<?php echo esc_url($sectionShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-2']['id'], '_wp_attachment_image_alt', true)); ?>" />
        <?php endif;

        if (!empty($sectionShape2)) :
        ?>
          <img class="shape-1 pulse" src="<?php echo esc_url($sectionShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-1']['id'], '_wp_attachment_image_alt', true)); ?>" />
        <?php endif; ?>
      </div>

    <?php elseif ("2" == $tjImagesStyle) : ?>
      <div class="sec-image-group-2">
        <?php if (!empty($sectionImage1)) :  ?>
          <div class="group-image-one pulse">
            <img class="lg-image" src="<?php echo esc_url($sectionImage1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-1']['id'], '_wp_attachment_image_alt', true)); ?>" />

            <?php if (!empty($sectionShape3)) :  ?>
              <img class="shape-3 pulse" src="<?php echo esc_url($sectionShape3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-3']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;


            if (!empty($sectionShape4)) :
            ?>
              <img class="shape-4 shake-y" src="<?php echo esc_url($sectionShape4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-4']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif; ?>
          </div>
        <?php endif;

        if (!empty($sectionImage2)) :
        ?>
          <div class="group-image-two pulse">
            <img class="lg-image" src="<?php echo esc_url($sectionImage2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-2']['id'], '_wp_attachment_image_alt', true)); ?>" />

            <?php if (!empty($sectionShape1)) :  ?>
              <img class="shape-1 pulse" src="<?php echo esc_url($sectionShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-1']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;

            if (!empty($sectionShape2)) :
            ?>
              <img class="shape-2 shake-y" src="<?php echo esc_url($sectionShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-2']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php else : ?>
      <div class="sec-image-group-1">
        <?php if (!empty($sectionImage1)) :  ?>
          <div class="faq-image1 pulse">
            <div class="group-image">
              <img src="<?php echo esc_url($sectionImage1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-1']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
            <?php if (!empty($sectionShape1)) :  ?>
              <img class="group-shape-1" src="<?php echo esc_url($sectionShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-1']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;

            if (!empty($sectionShape2)) :
            ?>
              <img class="group-shape-2" src="<?php echo esc_url($sectionShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-2']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <?php if (!empty($sectionImage2)) :  ?>
          <div class="faq-image3 pulse">
            <img src="<?php echo esc_url($sectionImage2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-2']['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>

        <?php if (!empty($sectionImage3)) :  ?>
          <div class="faq-image2 pulse">
            <div class="group-image">
              <img src="<?php echo esc_url($sectionImage3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-3']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>

            <?php if (!empty($sectionShape3)) :  ?>
              <img class="group-shape-3" src="<?php echo esc_url($sectionShape3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-3']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif;

            if (!empty($sectionShape4)) :
            ?>
              <img class="group-shape-4" src="<?php echo esc_url($sectionShape4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_shape-4']['id'], '_wp_attachment_image_alt', true)); ?>" />
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <?php if (!empty($sectionImage4)) :  ?>
          <div class="faq-image4 pulse">
            <img src="<?php echo esc_url($sectionImage4); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_sec_image-4']['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>

      </div>
    <?php endif; ?>
  </div>
<?php endif; ?>