<?php
// subtitle
$tjSectionSubtitle   = (!empty($settings['tj_subtitle'])) ? $settings['tj_subtitle'] : "";
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';

if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "subtitle wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj-subtitle-arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "subtitle";
}
$this->add_render_attribute('tj-subtitle-arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = (!empty($settings['tj_title'])) ? $settings['tj_title'] : "";
$tjSectionTitleTag   = (!empty($settings['tj_title_tag'])) ? $settings['tj_title_tag'] : "";
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

if (!empty($tjTitleAnimation)) {
  $titleClass = "title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} else {
  $titleClass = "title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// content
$tjShowContent   = (!empty($settings['is_content'])) ? "yes" : "no";
$tjSectionContent   = (!empty($settings['tj_content'])) ? $settings['tj_content'] : "";
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';

if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('tj-content-arg', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('tj-content-arg', 'class', $contentClass);
?>

<div class="tj-sec-heading style-6">
  <div class="tj_sec_left">
    <?php if (!empty($tjSectionSubtitle)) : ?>
      <span class="shadow_text wow slideInDown" data-wow-delay=".3s"><?php echo esc_html__($tjSectionSubtitle, "tjcore"); ?></span>
    <?php endif; ?>

    <?php if (!empty($tjSectionSubtitle)) : ?>
      <span <?php echo $this->get_render_attribute_string('tj-subtitle-arg'); ?>>
        <?php echo esc_html__($tjSectionSubtitle, "tjcore"); ?>
      </span>
    <?php endif; ?>

    <?php
    if (!empty($tjSectionTitle)) :
      printf(
        '<%1$s %2$s>%3$s</%1$s>',
        tag_escape($tjSectionTitleTag),
        $this->get_render_attribute_string('title_args'),
        tj_kses($tjSectionTitle)
      );
    endif;
    ?>
  </div>

  <?php if (!empty($tjSectionContent)) : ?>
    <div <?php echo $this->get_render_attribute_string('tj-content-arg'); ?>>
      <?php echo tj_kses($tjSectionContent); ?>
    </div>
  <?php endif; ?>

</div>