<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'services',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'services-cat',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'services-cat',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'services-cat',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}


// The Query
$query = new \WP_Query($args);


$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$dot            = (isset($settings['slide_dot']) && !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $serviceClass = "tj-services style-6 carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-service-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $serviceClass = "tj-services style-6 carouselWrap";
}
$this->add_render_attribute('tj-service-arg', 'class', $serviceClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-service-arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">

  <?php if ($query->have_posts()) : ?>
    <div class="row">
      <div class="col">
        <div class="services_carousel style-6 swiper swiper-container" id="servicesCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">

            <?php
            $n = 0;
            while ($query->have_posts()) : $query->the_post();
              $n++;

              $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
              $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
              $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
              $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';
            ?>
              <div class="swiper-slide">
                <div class="service_item style-6">

                  <?php if ('image-icon' == $serviceIconType) :

                    if (!empty($serviceImageIcon)) : ?>
                      <div class="service-icon">
                        <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                      </div>
                    <?php endif;

                  elseif ('fontawesome-icon' == $serviceIconType) :

                    if (!empty($serviceFontAwesomeIcon)) : ?>
                      <div class="service-icon">
                        <?php echo tj_kses($serviceFontAwesomeIcon); ?>
                      </div>
                    <?php endif;
                  else :

                    if (!empty($serviceIcon)) : ?>
                      <div class="service-icon">
                        <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                      </div>
                  <?php endif;
                  endif; ?>

                  <div class="service-content">
                    <h4 class="title">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h4>

                    <?php if (!empty(get_the_excerpt())) : ?>
                      <div class="desc">
                        <p><?php echo wp_trim_words(get_the_excerpt(), 23, '...'); ?></p>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_query(); ?>

          </div>

          <?php if ("yes" == $settings['slide_dot']) : ?>
            <div class="services_pagination"></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php else :
    printf("%s", esc_html__("No services available", 'tjcore'));
  endif; ?>
</div>