<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);


$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}


$args = array(
  'post_type' => 'services',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'services-cat',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'services-cat',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'services-cat',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}

// The Query
$query = new \WP_Query($args);
?>
<div class="tj_services">
  <?php if ($query->have_posts()) : ?>
    <div class="row">
      <div class="col">
        <?php
        $n = 0;
        while ($query->have_posts()) : $query->the_post();
          $n++;

          $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
          $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
          $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
          $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';

          // post category print 
          $service_cats = get_the_terms(get_the_ID(), 'services-cat');
        ?>
          <div class="tj-service-item-two wow fadeInUp" data-wow-delay="0.3s">
            <div class="service-content-info">
              <div class="service-left-content">

                <?php if ('image-icon' == $serviceIconType) :

                  if (!empty($serviceImageIcon)) : ?>
                    <div class="service-icon">
                      <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                    </div>
                  <?php endif;

                elseif ('fontawesome-icon' == $serviceIconType) :

                  if (!empty($serviceFontAwesomeIcon)) : ?>
                    <div class="service-icon">
                      <?php echo tj_kses($serviceFontAwesomeIcon); ?>
                    </div>
                  <?php endif;
                else :

                  if (!empty($serviceIcon)) : ?>
                    <div class="service-icon">
                      <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                    </div>
                <?php endif;
                endif; ?>

                <div class="service-text">
                  <h3 class="title-link">
                    <a class="sec-title" href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?></a>
                  </h3>
                  <span class="number"><?php printf("0%s", $n); ?></span>
                </div>
              </div>
              <?php if (has_post_thumbnail()) : ?>
                <div class="service-wrapper">
                  <?php the_post_thumbnail('full'); ?>
                </div>
              <?php endif; ?>
            </div>
            <div class="service-middle-content">
              <div class="service-text">
                <?php if ("yes" == $settings['tj_post_content']) : ?>
                  <div class="desc">
                    <p><?php echo wp_trim_words(get_the_excerpt(), $settings['tj_post_content_limit'], '...'); ?></p>
                  </div>
                <?php endif; ?>


                <?php if (!empty($service_cats)) : ?>
                  <div class="service-tags">
                    <?php foreach ($service_cats as $cat) :
                      $category_link = get_category_link($cat->term_id);
                    ?>
                      <a href="<?php echo esc_url($category_link); ?>" class="btn text-btn"><span><?php echo esc_html($cat->name); ?></span></a>
                    <?php endforeach; ?>
                  </div>
                <?php endif; ?>

              </div>
              <div class="service-arrow">
                <a href="<?php the_permalink(); ?>"><i class="flaticon-next"></i></a>
              </div>
            </div>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>
      </div>
    </div>

  <?php else :
    printf("%s", esc_html__("No service available", 'tjcore'));
  endif; ?>
</div>