<?php
$tjSkillsList   = (!empty($settings['tj_skills_list'])) ? $settings['tj_skills_list'] : '';

$tjAnimation   = $settings['tj_animation'] ?? '';

if (!empty($tjAnimation)) {
  $itemClass = "skill_item style-8  wow fadeInUp";
  $this->add_render_attribute('tj-item-arg', 'data-wow-delay', "0.3s");
} else {
  $itemClass = "skill_item style-8";
}
$this->add_render_attribute('tj-item-arg', 'class', $itemClass);
?>

<?php if (!empty($tjSkillsList)) : ?>
  <div class="skill_items_wrap">
    <?php foreach ($tjSkillsList as $key => $skill) : ?>
      <div <?php echo $this->get_render_attribute_string('tj-item-arg'); ?>>
        <div class="skill_item_inner">
          <?php if ("1" == $skill['tj_skill_icon_type']) : ?>
            <div class="skill_img">
              <?php tj_render_icon($skill, 'tj_icon', 'tj_skill_icon'); ?>
            </div>
          <?php else : ?>
            <div class="skill_img">
              <img src="<?php echo esc_url($skill['tj_skill_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($skill['tj_skill_image']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          <?php endif; ?>

          <div class="skill_content">
            <?php if (!empty($skill['tj_skill_title'])) : ?>
              <h4 class="title"><?php echo esc_html__($skill['tj_skill_title'], 'tjcore'); ?></h4>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php else :
  printf("No skill item found!");
endif;
?>