<?php
$socialQuery   = (!empty($settings['query_form'])) ? $settings['query_form'] : "";
$socials   = (!empty($settings['socials_list'])) ? $settings['socials_list'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $socialsClass = "team-details-social d-flex wow $tjAnimationName";
  $this->add_render_attribute('tj-socials-arg', 'class', $socialsClass);
  $this->add_render_attribute('tj-socials-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $socialsClass = "team-details-social d-flex";
  $this->add_render_attribute('tj-socials-arg', 'class', $socialsClass);
}

if ("teams" == $socialQuery) :

  $args = [
    'post_type' => 'post',
    'post_status' => 'publish',
    'p' => get_the_ID(),
  ];



  $socials = function_exists('get_field') ? get_field("member_socials", get_the_ID()) : '';
?>
  <?php if (!empty($socials)) : ?>
    <ul <?php echo $this->get_render_attribute_string('tj-socials-arg'); ?>>

      <?php foreach ($socials as $social) : ?>
        <li>
          <a href="<?php echo esc_url($social['social_link']); ?>">
            <?php echo tj_kses($social['social_icon']); ?>
          </a>
        </li>
      <?php endforeach; ?>

    </ul>
  <?php endif; ?>
  <?php
else :

  if (!empty($socials)) :
  ?>
    <ul <?php echo $this->get_render_attribute_string('tj-socials-arg'); ?>>

      <?php foreach ($socials as $social) :

        $link = !empty($social['tj_social_link']['url']) ? $social['tj_social_link']['url'] : '';
        $target = !empty($social['tj_social_link']['is_external']) ? '_blank' : '';
        $rel = !empty($social['tj_social_link']['nofollow']) ? 'nofollow' : '';
      ?>
        <li>
          <?php if (!empty($link)) :
            $href = 'href=' . $link . '';
            if (!empty($target)) :
              $target = 'target=' . $target . '';
            endif;
            if (!empty($rel)) :
              $rel = 'rel=' . $rel . '';
            endif;
          ?>
            <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
              <?php tj_render_icon($social, 'tj_social_icon', 'social_icon'); ?>
            </a>
          <?php else :
            tj_render_icon($social, 'tj_social_icon', 'social_icon');
          endif;
          ?>
        </li>
      <?php endforeach; ?>

    </ul>
<?php endif;
endif; ?>