<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}


$args = array(
  'post_type' => 'teams',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);


$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$dot            = (isset($settings['slide_dot']) && !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $serviceClass = "tj-teams-carousel carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-teams-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $serviceClass = "tj-teams-carousel carouselWrap";
}
$this->add_render_attribute('tj-teams-arg', 'class', $serviceClass);
?>

<section <?php echo $this->get_render_attribute_string('tj-teams-arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">

  <?php if ($query->have_posts()) : ?>
    <div class=" row align-items-center">
      <div class="col">
        <div class="swiper tj-team-slider" id="teamsCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">
            <?php
            $n = 0;

            while ($query->have_posts()) : $query->the_post();
              $n++;

              $designation = function_exists('get_field') ? get_field("designation", get_the_ID()) : '';
              $socials = function_exists('get_field') ? get_field("member_socials", get_the_ID()) : '';
            ?>
              <div class="swiper-slide team-style-5">
                <?php if (has_post_thumbnail()) : ?>
                  <div class="team-images">
                    <?php the_post_thumbnail('team_thumb_1'); ?>
                  </div>
                <?php endif; ?>

                <div class="tj-team-content">
                  <div class="team-header">
                    <h4 class="title-link"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                    <?php if (!empty($designation)) : ?>
                      <span class="sub-title"><?php echo esc_html__($designation, 'tjcore'); ?></span>
                    <?php endif; ?>

                  </div>
                  <?php if (!empty($socials)) : ?>
                    <div class="team-share">
                      <ul class="dot-style">
                        <?php foreach ($socials as $social) : ?>
                          <li>
                            <a href="<?php echo esc_url($social['social_link']); ?>">
                              <?php echo tj_kses($social['social_icon']); ?>
                            </a>
                          </li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endwhile;
            wp_reset_query(); ?>
          </div>

          <?php if ("yes" == $settings['slide_dot']) : ?>
            <div class="teams_pagination"></div>
          <?php endif; ?>

        </div>
      </div>
    </div>
  <?php else :
    printf("%s", esc_html__("No team member available", 'tjcore'));
  endif; ?>

</section>