<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}


$args = array(
  'post_type' => 'teams',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);

// view all button
$showViewAll = !empty($settings['tj_view_all_teams']) ? $settings['tj_view_all_teams'] : "";
$buttonText = !empty($settings['tj_viewall_button_text']) ? $settings['tj_viewall_button_text'] : esc_html__('View All', 'tjcore');

$tjBtnLinkType = !empty($settings['tj_btn_link_type']) ? $settings['tj_btn_link_type'] : "";
$tjBtnLink     = !empty($settings['tj_btn_link']) ? $settings['tj_btn_link'] : "";
$tjBtnPageLink = !empty($settings['tj_btn_page_link']) ? $settings['tj_btn_page_link'] : "";

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', "tj-secondary-btn btn-border");
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', "tj-secondary-btn btn-border");
  }
}
?>

<div class="tj-team-section">

  <?php if ($query->have_posts()) : ?>
    <div class="row justify-content-center">
      <?php
      $n = 0;

      while ($query->have_posts()) : $query->the_post();
        $n++;

        $designation = function_exists('get_field') ? get_field("designation", get_the_ID()) : '';
        $socials = function_exists('get_field') ? get_field("member_socials", get_the_ID()) : '';
      ?>
        <div class="col-xl-3 col-lg-4 col-md-6 col-12">
          <div class="tj-team-item team-style-four wow fadeInUp" data-wow-delay=".3s">

            <?php if (has_post_thumbnail()) : ?>
              <div class="team-image">
                <?php the_post_thumbnail('full'); ?>
              </div>
            <?php endif; ?>

            <div class="tj-team-content">
              <div class="team-header">
                <h5 class="title-link">
                  <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h5>
                <?php if (!empty($designation)) : ?>
                  <span class="sub-title"><?php echo esc_html__($designation, 'tjcore'); ?></span>
                <?php endif; ?>

              </div>

              <?php if (!empty($socials)) : ?>
                <div class="team-share">
                  <ul class="dot-style">
                    <?php foreach ($socials as $social) : ?>
                      <li>
                        <a href="<?php echo esc_url($social['social_link']); ?>">
                          <?php echo tj_kses($social['social_icon']); ?>
                        </a>
                      </li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </div>
      <?php endwhile;
      wp_reset_query(); ?>

      <?php if (!empty($showViewAll && $buttonText)) : ?>
        <div class="team-button text-center wow fadeInUp" data-wow-delay=".3s">
          <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>><span><?php echo esc_html__($buttonText, 'tjcore'); ?></span></a>
        </div>
      <?php endif; ?>

    </div>
  <?php else :
    printf("%s", esc_html__("No team member available", 'tjcore'));
  endif; ?>
</div>