<?php
$reviewList = (isset($settings['tj_review_list']) && !empty($settings['tj_review_list'])) ? $settings['tj_review_list'] : array();

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$nav            = (isset($settings['slide_nav']) && !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');


// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $testiClass = "tj-testimonial-section-three carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $testiClass = "tj-testimonial-section-three carouselWrap";
}
$this->add_render_attribute('tj-testimonial-arg', 'class', $testiClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?> data-loop="<?php echo $loop; ?>" data-nav="<?php echo $nav; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <div class="row align-items-center">
    <div class="col-lg-6 col-xl-5">
      <?php if (!empty($reviewList)) : ?>
        <div class="thumb-area">
          <div class="swiper tj-testimonial-slider3-thumb" id="testiCarouselThumb-<?php echo $this->get_id(); ?>">
            <div class="swiper-wrapper thumb_slider">

              <?php foreach ($reviewList as $key => $review) : ?>
                <div class="swiper-slide thumb_slide">
                  <?php if (!empty($review['tj_reviewer_image'])) : ?>
                    <img src="<?php echo esc_url($review['tj_reviewer_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($review['tj_reviewer_image']['id'], '_wp_attachment_image_alt', true)); ?>" />

                    <div class="thumb-arrow">
                      <i class="fa-solid fa-quote-right"></i>
                    </div>
                  <?php endif; ?>


                  <div class="testimonial-info">
                    <?php if (!empty($review['tj_reviewer_name'])) : ?>
                      <h4 class="title"><?php echo esc_html__($review['tj_reviewer_name'], 'tjcore'); ?></h4>
                    <?php endif; ?>

                    <?php if (!empty($review['tj_reviewer_designation'])) : ?>
                      <span class="sub-title"><?php echo esc_html__($review['tj_reviewer_name'], 'tjcore'); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endforeach; ?>

            </div>
          </div>
        </div>
      <?php endif; ?>
    </div>
    <div class="col-lg-6 col-xl-7">
      <?php if (!empty($reviewList)) : ?>
        <div class="swiper tj-testimonial-slider3" id="testiCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">

            <?php foreach ($reviewList as $key => $review) : ?>
              <div class="swiper-slide">
                <div class="testimonial-slider-item">

                  <?php if (!empty($review['tj_review_rating'])) : ?>
                    <div class="rating_wrap">
                      <div class="star-ratings">
                        <div class="fill-ratings" style="width: <?php echo esc_attr($review['tj_review_rating']['size']);
                                                                echo esc_attr($review['tj_review_rating']['unit']) ?>;">
                          <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                        </div>
                        <div class="empty-ratings">
                          <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                        </div>
                      </div>
                    </div>
                  <?php endif; ?>

                  <?php if (!empty($review['tj_review_text'])) : ?>
                    <div class="desc">
                      <p><?php echo tj_kses($review['tj_review_text']); ?></p>
                    </div>
                  <?php endif; ?>

                </div>
              </div>
            <?php endforeach; ?>

          </div>

          <?php if ("yes" == $nav) : ?>
            <div class="testimonial-navigation">
              <div class="swiper-button-prev"></div>
              <div class="swiper-button-next"></div>
            </div>
          <?php endif; ?>

        </div>
      <?php endif; ?>
    </div>
  </div>
</div>