<?php
$reviewList = (isset($settings['tj_review_list']) && !empty($settings['tj_review_list'])) ? $settings['tj_review_list'] : array();

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$dots            = (isset($settings['slide_dot']) && !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');


// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $testiClass = "testimonial-style-four carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $testiClass = "testimonial-style-four carouselWrap";
}
$this->add_render_attribute('tj-testimonial-arg', 'class', $testiClass);
?>
<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dots; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <div class="row">
    <div class="col-12">
      <div class="swiper tj-testimonial-slider4" id="testiCarousel-<?php echo $this->get_id(); ?>">
        <div class="swiper-wrapper">

          <?php foreach ($reviewList as $key => $review) : ?>
            <div class="swiper-slide">
              <div class="testimonial-item">
                <div class="testimonial-top-content">
                  <div class="testimonial-left-content">

                    <?php if (!empty($review['tj_reviewer_image'])) : ?>
                      <div class="auother-image">
                        <img src="<?php echo esc_url($review['tj_reviewer_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($review['tj_reviewer_image']['id'], '_wp_attachment_image_alt', true)); ?>" />
                      </div>
                    <?php endif; ?>

                    <div class="auother-text">
                      <?php if (!empty($review['tj_reviewer_name'])) : ?>
                        <h4 class="title"><?php echo esc_html__($review['tj_reviewer_name'], 'tjcore'); ?></h4>
                      <?php endif; ?>

                      <?php if (!empty($review['tj_reviewer_designation'])) : ?>
                        <span class="sub-title"><?php echo esc_html__($review['tj_reviewer_designation'], 'tjcore'); ?></span>
                      <?php endif; ?>
                    </div>
                  </div>
                  <div class="testimonial-right-content">

                    <?php if (!empty($review['tj_review_rating'])) : ?>
                      <div class="rating_wrap">
                        <div class="star-ratings">
                          <div class="fill-ratings" style="width: <?php echo esc_attr($review['tj_review_rating']['size']);
                                                                  echo esc_attr($review['tj_review_rating']['unit']) ?>;">
                            <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                          </div>
                          <div class="empty-ratings">
                            <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                          </div>
                        </div>
                      </div>
                    <?php endif; ?>

                    <div class="testimonial-quote">
                      <svg xmlns="http://www.w3.org/2000/svg" width="60" height="44" viewBox="0 0 60 44" fill="none">
                        <g opacity="0.3">
                          <path d="M0.573543 43.6491C0.382362 42.3418 0.238976 40.9878 0.143385 39.5872C0.0477951 38.1865 0 37.1594 0 36.5057C0 30.2495 1.14709 24.3201 3.44126 18.7175C5.73543 13.0215 8.55535 8.21259 11.901 4.29077L26.9565 7.65233C25.1403 11.6675 23.6586 16.1963 22.5116 21.2386C21.4601 26.281 20.9343 31.0899 20.9343 35.6653C20.9343 35.8521 20.9343 36.2723 20.9343 36.9259C20.9343 37.4862 20.9343 38.1865 20.9343 39.0269C21.0299 39.7739 21.0777 40.5676 21.0777 41.408C21.1733 42.2484 21.2689 42.9954 21.3645 43.6491H0.573543Z" fill="#DCDEE7" />
                          <path d="M59.4259 0.0126953C59.6171 1.31997 59.7605 2.67393 59.8561 4.07458C59.9517 5.47523 59.9995 6.50238 59.9995 7.15602C59.9995 13.4123 58.8524 19.3884 56.5582 25.0843C54.2641 30.687 51.4441 35.4492 48.0985 39.371L33.043 36.0094C34.8592 31.9942 36.293 27.4654 37.3445 22.4231C38.4916 17.3808 39.0652 12.5719 39.0652 7.9964C39.0652 7.80965 39.0652 7.43614 39.0652 6.87588C39.0652 6.22224 39.0174 5.52192 38.9218 4.77491C38.9218 3.93451 38.874 3.09412 38.7784 2.25373C38.7784 1.41334 38.7306 0.66633 38.635 0.0126953H59.4259Z" fill="#DCDEE7" />
                        </g>
                      </svg>
                    </div>
                  </div>
                </div>

                <?php if (!empty($review['tj_review_text'])) : ?>
                  <div class="review_text">
                    <p><?php echo tj_kses($review['tj_review_text']); ?></p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>

        </div>

        <?php if ("yes" == $dots) : ?>
          <div class="swiper-pagination"></div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>