<?php
$videoImage   = (isset($settings['tj_video_image']['url']) && $settings['tj_video_image']['url'] != '') ? $settings['tj_video_image']['url'] : '';
$videoLink   = (!empty($settings['tj_video_link'])) ? $settings['tj_video_link'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $videoClass = "video-image wow $tjAnimationName";
  $this->add_render_attribute('tj-video-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $videoClass = "video-image";
}
$this->add_render_attribute('tj-video-arg', 'class', $videoClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-video-arg'); ?>>
  <?php if (!empty($videoImage)) : ?>
    <img src="<?php echo esc_url($videoImage); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_video_image']['id'], '_wp_attachment_image_alt', true)); ?>" />
  <?php endif; ?>

  <?php if (!empty($videoLink)) : ?>
    <div class="video-play">
      <a class="venobox popup-videos-button" data-autoplay="true" data-vbtype="video" href="<?php echo esc_url($videoLink); ?>">
        <?php tj_render_icon($settings, 'video_icon', 'tj_video_icon'); ?>
      </a>
    </div>
  <?php endif; ?>
</div>