<?php
$videoImage   = (isset($settings['tj_video_image']['url']) && $settings['tj_video_image']['url'] != '') ? $settings['tj_video_image']['url'] : '';
$videoLink   = (!empty($settings['tj_video_link'])) ? $settings['tj_video_link'] : "";

// Shapes
$videoShape1 = !empty($settings['tj_video_shape_1']['url']) ? $settings['tj_video_shape_1']['url'] : '';
$videoShape2 = !empty($settings['tj_video_shape_2']['url']) ? $settings['tj_video_shape_2']['url'] : '';
$videoShape3 = !empty($settings['tj_video_shape_3']['url']) ? $settings['tj_video_shape_3']['url'] : '';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $videoClass = "tj-video-section videoImage wow $tjAnimationName";
  $this->add_render_attribute('tj-video-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $videoClass = "tj-video-section videoImage";
}
$this->add_render_attribute('tj-video-arg', 'class', $videoClass);

if (!empty($videoImage)) {
  $bgImage = 'data-bg-image=' . $videoImage . '';
} else {
  $bgImage = "";
}
?>
<div <?php echo $this->get_render_attribute_string('tj-video-arg'); ?> <?php echo esc_attr($bgImage); ?>>
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="video-area">
          <div class="tj-video-popup">
            <?php if (!empty($videoLink)) : ?>
              <div class="circle pulse video-icon">
                <a class="venobox popup-videos-button" data-autoplay="true" data-vbtype="video" href="<?php echo esc_url($videoLink); ?>">
                  <?php tj_render_icon($settings, 'video_icon', 'tj_video_icon'); ?>
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="video-sec-shape">
    <?php if (!empty($videoShape1)) :  ?>
      <div class="shape-1 shake-y">
        <img src="<?php echo esc_url($videoShape1); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_video_shape_1']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif; ?>

    <?php if (!empty($videoShape2)) :  ?>
      <div class="shape-2 shake-y">
        <img src="<?php echo esc_url($videoShape2); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_video_shape_2']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif; ?>

    <?php if (!empty($videoShape3)) :  ?>
      <div class="shape-3 pulse">
        <img src="<?php echo esc_url($videoShape3); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_video_shape_3']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php endif; ?>
  </div>
</div>