<?php
$videoTitle   = (!empty($settings['tj_video_title'])) ? $settings['tj_video_title'] : "";
$videoLink   = (!empty($settings['tj_video_link'])) ? $settings['tj_video_link'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $videoClass = "tj-video-area wow $tjAnimationName";
  $this->add_render_attribute('tj-video-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $videoClass = "tj-video-area";
}
$this->add_render_attribute('tj-video-arg', 'class', $videoClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-video-arg'); ?>>
  <?php if (!empty($videoLink)) : ?>
    <div class="video-play">
      <a class="venobox popup-videos-button" data-autoplay="true" data-vbtype="video" href="<?php echo esc_url($videoLink); ?>">
        <?php tj_render_icon($settings, 'video_icon', 'tj_video_icon'); ?>
      </a>
    </div>
  <?php endif; ?>

  <?php if (!empty($videoTitle)) : ?>
    <div class="video-text">
      <h6 class="title"><?php echo esc_html__($videoTitle, 'tjcore'); ?></h6>
    </div>
  <?php endif; ?>
</div>