<?php
$videoImage   = (isset($settings['tj_video_image']['url']) && $settings['tj_video_image']['url'] != '') ? $settings['tj_video_image']['url'] : '';
$videoLink   = (!empty($settings['tj_video_link'])) ? $settings['tj_video_link'] : "";
$videoTitle   = (!empty($settings['tj_video_title'])) ? $settings['tj_video_title'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $videoClass = "tj-video-section style-6 videoImage wow $tjAnimationName";
  $this->add_render_attribute('tj-video-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $videoClass = "tj-video-section style-6 videoImage";
}
$this->add_render_attribute('tj-video-arg', 'class', $videoClass);

if (!empty($videoImage)) {
  $bgImage = 'data-bg-image=' . $videoImage . '';
} else {
  $bgImage = "";
}
?>

<div <?php echo $this->get_render_attribute_string('tj-video-arg'); ?> <?php echo esc_attr($bgImage); ?>>
  <div class="container">
    <div class="row">
      <div class="col">
        <div class="video_content_wrap">
          <?php if (!empty($videoLink)) : ?>
            <div class="video_icon">
              <a class="popup-videos-button video_play" href="<?php echo esc_url($videoLink); ?>">
                <?php tj_render_icon($settings, 'video_icon', 'tj_video_icon'); ?>
              </a>
            </div>
          <?php endif; ?>

          <?php if (!empty($videoTitle)) : ?>
            <div class="video_text"><?php echo esc_html__($videoTitle, 'tjcore'); ?></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>