<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for About Image.
 */
class TJ_About_Image extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-about-image';
  }

  // widget title.
  public function get_title() {
    return __('TJ About Image', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-wordart tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'about image',
      'image',
      'tj about image',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('About Image Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select About Image Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_section_content
    $this->start_controls_section(
      'tj_section_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_about_image',
      [
        'label' => esc_html__('About Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ["1", "4"],
        ]
      ]
    );
    $this->add_control(
      'tj_about_other_image-1',
      [
        'label' => esc_html__('Other Image 1', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_about_other_image-2',
      [
        'label' => esc_html__('Other Image 2', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_about_other_image-3',
      [
        'label' => esc_html__('Other Image 3', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ["1", "4"],
        ]
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // about ticker
    $this->start_controls_section(
      'tj_about_ticker',
      [
        'label' => esc_html__('About Ticker', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ["3", "4", "5", "6", "7", "8"],
        ]
      ]
    );
    $this->add_control(
      'tj_ticker_show',
      [
        'label'        => esc_html__('Show About ticker?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_ticker_text',
      [
        'label'     => esc_html__('Ticker Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Creative Minds_, Creative Minds', 'tjcore'),
        'label_block'      => true,
        'condition' => [
          'tj_ticker_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_about_ticker_shape',
      [
        'label'   => esc_html__('Ticker Shape', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_ticker_show' => 'yes',
        ],
        'condition' => [
          'tj_design_style' => "1",
        ]
      ]
    );
    $this->end_controls_section();

    // about video
    $this->start_controls_section(
      'tj_about_video',
      [
        'label' => esc_html__('About Video', 'tjcore'),
        'condition' => [
          'tj_design_style' => ["8"],
        ]
      ]
    );
    $this->add_control(
      'tj_video_link',
      [
        'label'       => esc_html__('Video Link', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_url('https://www.youtube.com/watch?v=E1xkXZs0cAQ'),
        'label_block' => 'true',
      ]
    );
    $this->add_control(
      'tj_video_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'video_icon',
        'default'          => [
          'value' => 'fa-play',
          'library' => 'fa-solid',
        ],
      ]
    );
    $this->end_controls_section();

    // tj_about_shape
    $this->start_controls_section(
      'tj_about_shape',
      [
        'label' => esc_html__('About Shapes', 'tjcore'),
        'condition' => [
          'tj_design_style!' => "5",
        ]
      ]
    );
    $this->add_control(
      'tj_shapes_show',
      [
        'label'        => esc_html__('Show About shapes?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_about_shape_1',
      [
        'label'   => esc_html__('About Shape 1', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_about_shape_2',
      [
        'label'   => esc_html__('About Shape 2', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style!' => ["6", "7"],
        ],
      ]
    );
    $this->add_control(
      'tj_about_shape_3',
      [
        'label'   => esc_html__('About Shape 3', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_design_style' => ["1", "3", "4"],
          'tj_shapes_show' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['8']
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient Border Color', 'tjcore'),
          ],
        ],
        'name' => 'tj_border_gradient_color_1',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .about-image1, {{WRAPPER}} .about-image3, {{WRAPPER}} .image-group-1::after',
        'condition' => [
          'tj_design_style' => ['1', '3', '4']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_border_color_1',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .about-images-wrapper.style-8 .group-image-2' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['7']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_shape_color_1',
      [
        'label'     => __('Primary Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .about-image2 img' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .about-images-wrapper.style-7 .images-one' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .about-images-wrapper.style-7 .images-two img' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .about-images-wrapper.style-8 .group-image-1::before' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['1', '4', '6', '7']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_shape_color_2',
      [
        'label'     => __('Secondary Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .about-image4 img' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['1', '4']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient BG Shape 1', 'tjcore'),
          ],
        ],
        'name' => 'tj_shape_gradient_color_1',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .about-image1::before, {{WRAPPER}} .about-image1::after, {{WRAPPER}} .image_left::after, {{WRAPPER}} .about-images-wrapper.style-7::before',
        'condition' => [
          'tj_design_style' => ['4', '5', '6']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient BG Shape 2', 'tjcore'),
          ],
        ],
        'name' => 'tj_shape_gradient_color_2',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .image_left .image_left_inner',
        'condition' => [
          'tj_design_style' => ['5']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_shape_bg_color_1',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .image-group-1::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .image-group-2::before' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2']
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();

    // video play
    $this->start_controls_section(
      '_section_style_play_btn',
      [
        'label' => esc_html__('Play Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => '8'
        ]
      ]
    );
    $this->add_control(
      'tj_play_background_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .video_icon' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_play_btn_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .video_icon .video_play' => 'color: {{VALUE}}',
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/about-image/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_About_Image());
