<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Animated Image.
 */
class TJ_Animated_Image extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-animated-image';
  }

  // widget title.
  public function get_title() {
    return __('TJ Animated Image', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-image-rollover tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'image',
      'media',
      'tj animated image',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Images Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Images Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_image_content
    $this->start_controls_section(
      '_tj_image_content',
      [
        'label' => esc_html__('Images', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image_1',
      [
        'label'   => esc_html__('Image 01', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_image_2',
      [
        'label'   => esc_html__('Image 02', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style!' => ["6"]
        ]
      ]
    );
    $this->add_control(
      'tj_image_3',
      [
        'label'   => esc_html__('Image 03', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style!' => ["4", "6"]
        ]
      ]
    );
    $this->add_control(
      'tj_image_4',
      [
        'label'   => esc_html__('Image 04', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ["2", "5"]
        ]
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // shapes
    $this->start_controls_section(
      '_tj_image_shapes',
      [
        'label' => esc_html__('Shapes', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ["4", "6"]
        ]
      ]
    );
    $this->add_control(
      'tj_shape_1',
      [
        'label'   => esc_html__('Shape 01', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
      ]
    );
    $this->add_control(
      'tj_shape_2',
      [
        'label'   => esc_html__('Shape 02', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_design_style!' => "3"
        ]
      ]
    );
    $this->add_control(
      'tj_shape_3',
      [
        'label'   => esc_html__('Shape 03', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_design_style!' => "3"
        ]
      ]
    );
    $this->add_control(
      'tj_shape_4',
      [
        'label'   => esc_html__('Shape 04', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_design_style' => ["2", "5"]
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient Border Color', 'tjcore'),
          ],
        ],
        'name' => 'tj_border_gradient_color_1',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .faq-image-one',
        'condition' => [
          'tj_design_style' => ['2']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_shape_color_1',
      [
        'label'     => __('Primary Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-image2 .group-image img' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .faq-image4 img' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .images-one img' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .images-two img' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .faq-image-one' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .faq-image3' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .faq-image3' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2', '4', '5']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_shape_color_2',
      [
        'label'     => __('Secondary Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-image3 img' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient BG Shape 1', 'tjcore'),
          ],
        ],
        'name' => 'tj_shape_gradient_color_1',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .faq-image-group::before, {{WRAPPER}} .faq-image-group::after, {{WRAPPER}} .group-image::before, {{WRAPPER}} .faq-image2::before, {{WRAPPER}} .images-one::before',
        'condition' => [
          'tj_design_style' => ['2', '3', '4']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient BG Shape 2', 'tjcore'),
          ],
        ],
        'name' => 'tj_shape_gradient_color_2',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .faq-image3::before',
        'condition' => [
          'tj_design_style' => ['3']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_shape_bg_color_1',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .group-image-1::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .group-image-2::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .group-image-3::before' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['1']
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_banner_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/animated-image/style-' . $tj_banner_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Animated_Image());
