<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Elementor widget for Button.
 */
class Tj_Button extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-button';
  }

  // widget title.
  public function get_title() {
    return esc_html__('TJ Button', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-button tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'button',
      'btn',
      'tj button',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    $this->start_controls_section(
      '__tj_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'button_type',
      [
        'label' => esc_html__('Button Type', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Default', 'tjcore'),
          '2' => esc_html__('Black', 'tjcore'),
        ],
      ]
    );

    $this->add_control(
      'tj_btn_text',
      [
        'label'   => esc_html__('Button Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Click here', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_align',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'left'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
          'justify'  => [
            'title' => esc_html__('Justified', 'tjcore'),
            'icon'  => 'eicon-text-align-justify',
          ],
        ],
        'default'      => 'center',
        'prefix_class' => 'elementor%s-align-',
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => '',
          'library' => '',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );
    $this->add_control(
      'btn_icon_spacing',
      [
        'label'      => esc_html__('Icon Spacing', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 100,
            'step' => 1,
          ],
        ],
        'condition'  => [
          'tj_btn_icon[value]!' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj_btn_wrapper .tj-btn-inline i'  => 'margin-left: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn i' => 'margin-left: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_id',
      [
        'label'       => esc_html__('Button ID', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'          => [
          'active' => false,
        ],
        'default'     => '',
        'title'       => esc_html__('Add your custom id WITHOUT the Pound key. e.g: my-id', 'tjcore'),
        'description' => sprintf(
          esc_html__('Please make sure the ID is unique and not used elsewhere on the page this form is displayed. This field allows %1$sA-z 0-9%2$s & underscore chars without spaces.', 'tjcore'),
          '<code>',
          '</code>'
        ),
        'separator'   => 'before',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_heading_btn',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn, {{WRAPPER}} .tj-black-btn',
      ]
    );
    $this->start_controls_tabs(
      'btn_tabs'
    );
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Background Color', 'tjcore'),
          ]
        ],
        'name' => 'btn_background_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn, {{WRAPPER}} .tj-black-btn',
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Background Color', 'tjcore'),
          ]
        ],
        'name' => 'btn_background_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-primary-btn:hover, {{WRAPPER}} .tj-black-btn::before',
      ]
    );
    $this->add_control(
      'btn_border_hover_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn:hover' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'btn_border_style',
      [
        'label'     => esc_html__('Border Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''       => esc_html__('Default', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
          'solid'  => esc_html__('Solid', 'tjcore'),
          'dashed' => esc_html__('Dashed', 'tjcore'),
          'dotted' => esc_html__('Dotted', 'tjcore'),
          'double' => esc_html__('Double', 'tjcore'),
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-style: {{VALUE}};',
          '{{WRAPPER}} .tj-black-btn' => 'border-style: {{VALUE}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_border_width',
      [
        'label'      => esc_html__('Border Width', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_control(
      'btn_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render() {
    $settings = $this->get_settings_for_display();

    if ("2" == $settings['button_type']) {
      $btnClass = "elementor-button btn tj-black-btn";
    } else {
      $btnClass = "elementor-button tj-primary-btn";
    }

    $tjBtnText     = $settings['tj_btn_text'];
    $tjBtnLinkType = $settings['tj_btn_link_type'];
    $tjBtnLink     = $settings['tj_btn_link'];
    $tjBtnPageLink = $settings['tj_btn_page_link'];
    $tjBtnId       = $settings['tj_btn_id'];

    // animation
    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $buttonClass          = "$btnClass wow $tjAnimationName";
      $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $buttonClass          = "$btnClass";
    }

    if ('2' == $tjBtnLinkType) {
      $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
      $this->add_render_attribute('tj-button-arg', 'target', '_self');
      $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
      $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
      if (!empty($tjBtnId)) {
        $this->add_render_attribute('tj-button-arg', 'id', $tjBtnId);
      }
    } else {
      if (!empty($tjBtnLink['url'])) {
        $this->add_link_attributes('tj-button-arg', $tjBtnLink);
        $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);
        if (!empty($tjBtnId)) {
          $this->add_render_attribute('tj-button-arg', 'id', $tjBtnId);
        }
      }
    }

?>
    <div class="tj_btn_wrapper">

      <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
        <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
        <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
          <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
        <?php endif; ?>
      </a>

    </div>

<?php
  }
  protected function content_template() {
  }
}

$widgets_manager->register(new Tj_Button());
