<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Form.
 */
class TJ_Form extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-form';
  }

  // widget title.
  public function get_title() {
    return __('TJ Form', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-form-horizontal tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'form',
      'form',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form() {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Form Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Form Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_tj_form',
      [
        'label' => esc_html__('TJ Form', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '0',
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .contact-form-box, {{WRAPPER}} .contact-form-box2',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .contact-form-box2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .contact-form-box2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // From Style
    $this->start_controls_section(
      'section_tab_area',
      [
        'label' => esc_html__('Form Field Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} select, {{WRAPPER}} .nice-select, {{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} textarea, {{WRAPPER}} .wpcf7-list-item-label',
      ]
    );
    $this->add_responsive_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'color: {{VALUE}}',
          '{{WRAPPER}} select'                                                                => 'color: {{VALUE}}',
          '{{WRAPPER}} .nice-select'                                                          => 'color: {{VALUE}}',
          '{{WRAPPER}} textarea'                                                              => 'color: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-list-item-label'                                                => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} textarea::-moz-placeholder'                                            => 'color: {{VALUE}}',
          '{{WRAPPER}} .nice-select::-moz-placeholder'                                        => 'color: {{VALUE}}',
          '{{WRAPPER}} input::-moz-placeholder'                                               => 'color: {{VALUE}}',

          '{{WRAPPER}} textarea::-ms-input-placeholder'                                       => 'color: {{VALUE}}',
          '{{WRAPPER}} .nice-select::-ms-input-placeholder'                                   => 'color: {{VALUE}}',
          '{{WRAPPER}} input::-ms-input-placeholder'                                          => 'color: {{VALUE}}',

          '{{WRAPPER}} textarea::-webkit-input-placeholder'                                   => 'color: {{VALUE}}',
          '{{WRAPPER}} .nice-select::-webkit-input-placeholder'                               => 'color: {{VALUE}}',
          '{{WRAPPER}} input::-webkit-input-placeholder'                                      => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} select'                                                                => 'background: {{VALUE}}',
          '{{WRAPPER}} .nice-select'                                                          => 'background: {{VALUE}}',
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'background: {{VALUE}}',
          '{{WRAPPER}} textarea'                                                              => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'cf_borders',
        'label'    => esc_html__('Field Border', 'tjcore'),
        'selector' => '{{WRAPPER}} select, {{WRAPPER}} .nice-select, {{WRAPPER}} input:not([type="submit"]):not([type="range"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} textarea',
      ]
    );
    $this->add_responsive_control(
      'cf_field_radius',
      [
        'label'      => esc_html__('Field Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} select'                                                                => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .nice-select'                                                          => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} textarea'                                                              => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'cf_field_shadow',
        'label'    => esc_html__('Field Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} select, {{WRAPPER}} .nice-select, {{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} textarea',
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} select'                                                                => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .nice-select'                                                          => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_margin',
      [
        'label'      => esc_html__('Field Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} select'                                                                => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .nice-select'                                                          => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_filed_height',
      [
        'label'      => esc_html__('Input/Select Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 100,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} input[type="text"]'   => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} input[type="email"]'  => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} input[type="url"]'    => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} input[type="tel"]'    => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} input[type="number"]' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} input[type="date"]'   => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} select'               => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .nice-select'         => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_message_height',
      [
        'label'      => esc_html__('Textarea Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 500,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} textarea' => 'height: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'text_area_box_radius',
      [
        'label'      => esc_html__('Textarea Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_textarea_typo',
        'label'    => esc_html__('Textarea Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} textarea',
      ]
    );
    $this->add_responsive_control(
      'cf_message_padding',
      [
        'label'      => esc_html__('Textarea Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_message_margin',
      [
        'label'      => esc_html__('Textarea Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      'section_tab_button',
      [
        'label' => esc_html__('Button Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} input[type=submit], {{WRAPPER}} button[type=submit]',
      ]
    );
    $this->start_controls_tabs('style_tabs_1');
    $this->start_controls_tab(
      'btn_1_button_style_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_1_label_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input[type=submit]'  => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_1_bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} input[type=submit], {{WRAPPER}} button[type=submit]',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'btn_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} input[type=submit], {{WRAPPER}} button[type=submit]',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'btn_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} input[type=submit], {{WRAPPER}} button[type=submit]',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'btn_1_button_style_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_label_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input[type=submit]:hover'  => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_hover__bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} input[type=submit]:hover, {{WRAPPER}} button[type=submit]:hover',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'btn_hover_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} input[type=submit]:hover, {{WRAPPER}} button[type=submit]:hover',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'btn_hover_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} input[type=submit]:hover, {{WRAPPER}} button[type=submit]:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'btn_1_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [],
        'selectors'  => [
          '{{WRAPPER}} input[type=submit]'  => 'width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} button[type=submit]' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_1_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [],
        'selectors'  => [
          '{{WRAPPER}} input[type=submit]'  => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} button[type=submit]' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/form/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Form());
