<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Header.
 */
class TJ_Header extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-header';
  }

  // widget title.
  public function get_title() {
    return __('TJ Main Headers', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-header tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore-header'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'header',
      'headers',
      'tj header',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls() {

    $menus = wp_get_nav_menus();
    $menulist = array('0' => esc_html__('None', 'tjcore'));
    if (!empty($menus)) {
      foreach ($menus as $menu) {
        $menulist[$menu->term_id] = $menu->name;
      }
    }

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Header Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Header Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_header_topbar_tab
    $this->start_controls_section(
      'tj_header_topbar_tab',
      [
        'label' => esc_html__('Topbar', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_control(
      'show_header_topbar',
      [
        'label' => esc_html__('Is Header Topbar?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show header topbar?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );
    $contactInfo = new Repeater();
    $contactInfo->add_control(
      'tj_contact_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'contact_icon',
        'default'          => [
          'value' => 'fas fa-phone',
          'library' => 'fa-solid',
        ],
      ]
    );
    $contactInfo->add_control(
      'tj_contact_label',
      [
        'label'   => esc_html__('Label', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('(000) 123 456 789', 'tjcore'),
        'label_block' => true,
        'ai' => false,
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $contactInfo->add_control(
      'tj_contact_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_contact_list',
      [
        'label' => esc_html__('Contact List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $contactInfo->get_controls(),
        'default' => [
          [
            'tj_social_icon' => [
              'value' => 'fa-regular fa-phone',
              'library' => 'fa-regular',
            ],
            'tj_contact_label' => esc_attr('(000) 123 456 789'),
          ],
          [
            'tj_social_icon' => [
              'value' => 'fa-regular fa-envelope',
              'library' => 'fa-regular',
            ],
            'tj_contact_label' => esc_attr('info@gmail.com'),
          ],
          [
            'tj_social_icon' => [
              'value' => 'fa-regular fa-location-dot',
              'library' => 'fa-regular',
            ],
            'tj_contact_label' => esc_attr('684 West College St. City, USA'),
          ],
        ],
        'title_field' => '{{tj_contact_label}}',
        'separator' => 'after',
        'condition' => [
          'show_header_topbar' => "yes"
        ]
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'tj_social_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'social_icon',
        'default'          => [
          'value' => 'fab fa-facebook-f',
          'library' => 'fa-brands',
        ],
      ]
    );
    $repeater->add_control(
      'tj_social_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $this->add_control(
      'tj_socials_list',
      [
        'label' => esc_html__('Socials List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_social_icon' => [
              'value' => 'fab fa-facebook-f',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_social_icon' => [
              'value' => 'fab fa-instagram',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_social_icon' => [
              'value' => 'fab fa-twitter',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_social_icon' => [
              'value' => 'fab fa-linkedin-in',
              'library' => 'fa-brands',
            ],
          ]
        ],
        'title_field' => '{{{ elementor.helpers.renderIcon( this, tj_social_icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}}',
        'condition' => [
          'show_header_topbar' => "yes"
        ]
      ]
    );
    $this->end_controls_section();

    // tj_main_header_tab
    $this->start_controls_section(
      'tj_main_header_tab',
      [
        'label' => esc_html__('Main Header', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_logo',
      [
        'label' => esc_html__('Logo', 'tjcore'),
        'type'  => Controls_Manager::MEDIA,
        'description' => esc_html__('Upload your site logo.', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    // Navigation
    $this->add_control(
      'tj_navigation',
      [
        'label'     => esc_html__('Select Menu', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '0',
        'options'   => $menulist,
        'separator' => 'before',
      ]
    );

    // button
    $this->add_control(
      'is_header_btn',
      [
        'label' => esc_html__('Is Header Button?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show header button?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'   => esc_html__('Button Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Contact Us', 'tjcore'),
        'label_block' => true,
        'ai' => false,
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'is_header_btn' => "yes"
        ]
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'condition' => [
          'is_header_btn' => "yes"
        ]
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'is_header_btn' => "yes",
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'is_header_btn' => "yes",
          'tj_btn_link_type' => '2',
        ],
      ]
    );

    $this->add_control(
      'is_header_absolute',
      [
        'label' => esc_html__('Is Absolute Header?', 'tjcore'),
        'type'  => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show absolute header?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'is_header_sticky',
      [
        'label' => esc_html__('Is Sticky Header?', 'tjcore'),
        'type'  => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show sticky header?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $this->end_controls_section();

    // tj_hamburger_tab
    $this->start_controls_section(
      'tj_hamburger_tab',
      [
        'label' => esc_html__('Hamburger Menu', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    // hamburger icon
    $this->add_control(
      'tj_hamburger_icon',
      [
        'label'            => esc_html__('Hamburger Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'hamburger_icon',
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );

    // mobile logo
    $this->add_control(
      'tj_mobile_logo',
      [
        'label' => esc_html__('Mobile Logo', 'tjcore'),
        'type'  => Controls_Manager::MEDIA,
        'description' => esc_html__('Upload your site logo.', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    // search
    $this->add_control(
      'is_mobile_search',
      [
        'label' => esc_html__('Is Mobile Search?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show mobile search?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );

    // contact info
    $this->add_control(
      'is_mobile_contact',
      [
        'label' => esc_html__('Is Mobile Contact?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show mobile contact?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );
    $contactInfo = new Repeater();
    $contactInfo->add_control(
      'tj_contact_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'contact_icon',
      ]
    );
    $contactInfo->add_control(
      'contact_label',
      [
        'label' => esc_html__('Label', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('mail@webency.com', 'tjcore'),
        'label_block' => true,
      ]
    );
    $contactInfo->add_control(
      'contact_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'contact_list',
      [
        'label' => esc_html__('Contact List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $contactInfo->get_controls(),
        'default' => [
          [
            'tj_contact_icon' => [
              'value' => 'fas fa-envelope',
              'library' => 'fa-solid',
            ],
            'contact_label' => esc_html__('mail@webency.com', 'tjcore'),
          ],
          [
            'tj_contact_icon' => [
              'value' => 'fas fa-phone-alt',
              'library' => 'fa-solid',
            ],
            'contact_label' => esc_html__('+(081)-2345-6789', 'tjcore'),
          ],
          [
            'tj_contact_icon' => [
              'value' => 'fas fa-map-marker-alt',
              'library' => 'fa-solid',
            ],
            'contact_label' => esc_html__('225 Marion Street, Columbia', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ contact_label }}}',
        'condition'   => [
          'is_mobile_contact' => "yes",
        ],
      ]
    );

    // Socials
    $this->add_control(
      'is_mobile_socials',
      [
        'label' => esc_html__('Is Mobile Socials?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show mobile socials?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );
    $socials = new Repeater();
    $socials->add_control(
      'tj_social_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'social_icon',
      ]
    );
    $socials->add_control(
      'social_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'socials_list',
      [
        'label' => esc_html__('Socials List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $socials->get_controls(),
        'default' => [
          [
            'tj_social_icon' => [
              'value' => 'fab fa-facebook-f',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_social_icon' => [
              'value' => 'fab fa-instagram',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_social_icon' => [
              'value' => 'fab fa-twitter',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_social_icon' => [
              'value' => 'fab fa-linkedin-in',
              'library' => 'fa-brands',
            ],
          ],
        ],
        'title_field' => '{{{ elementor.helpers.renderIcon( this, tj_social_icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}}',
        'condition'   => [
          'is_mobile_socials' => "yes",
        ],
      ]
    );

    // button
    $this->add_control(
      'is_mobile_header_btn',
      [
        'label' => esc_html__('Is Mobile Button?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'description' => esc_html__('Do you want to show mobile button?', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'no',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_mobile_btn_text',
      [
        'label'   => esc_html__('Button Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Contact Us', 'tjcore'),
        'label_block' => true,
        'ai' => false,
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'is_mobile_header_btn' => "yes"
        ]
      ]
    );
    $this->add_control(
      'tj_mobile_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'condition' => [
          'is_mobile_header_btn' => "yes"
        ]
      ]
    );
    $this->add_control(
      'tj_mobile_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'is_mobile_header_btn' => "yes",
          'tj_mobile_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_mobile_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'is_mobile_header_btn' => "yes",
          'tj_mobile_btn_link_type' => '2',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'header_topbar_style',
      [
        'label' => esc_html__('Topbar', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'      => 'topbar_background',
        'label'     => esc_html__('Background', 'tjcore'),
        'types'     => ['classic', 'gradient'],
        'selector'  => '{{WRAPPER}} .header-topbar.style-9',
      ]
    );
    $this->add_responsive_control(
      'topbar_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-infos ul li' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .topbar-share9 ul li' => 'border-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'top_contact_heading',
      [
        'label' => esc_html__('Contact Info', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'top_contact_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .topbar-infos ul li',
      ]
    );
    $this->start_controls_tabs('style_top_content_tabs');
    $this->start_controls_tab(
      'top_contact_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'topbar_contact_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-infos ul li' => 'color: {{VALUE}}',
          '{{WRAPPER}} .topbar-infos ul li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .topbar-infos ul li a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'top_contact_hover_tab',
      [
        'label' => esc_html__('hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'topbar_contact_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-infos ul li a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .topbar-infos ul li a:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'top_socials_heading',
      [
        'label' => esc_html__('Socials Info', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->start_controls_tabs('style_top_socials_tabs');
    $this->start_controls_tab(
      'top_social_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'topbar_social_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-share9 ul li a' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'topbar_social_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-share9 ul li a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'top_social_hover_tab',
      [
        'label' => esc_html__('hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'topbar_social_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-share9 ul li a:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'topbar_social_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .topbar-share9 ul li a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .topbar-share9 ul li a:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // main header
    $this->start_controls_section(
      'main_header_style',
      [
        'label' => esc_html__('Main Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('style_tabs');
    $this->start_controls_tab(
      'header_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'      => 'header_normal_background',
        'label'     => esc_html__('Background', 'tjcore'),
        'types'     => ['classic', 'gradient'],
        'selector'  => '{{WRAPPER}} .tj-header-area, {{WRAPPER}} .tj-header-area .menu-area.style-9',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name' => 'header_normal_border',
        'label' => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-header-area, {{WRAPPER}} .tj-header-area .menu-area.style-9',
      ]
    );
    $this->add_control(
      'header_normal_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-header-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'header_normal_box_shadow',
        'label' => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-header-area',
      ]
    );
    $this->add_responsive_control(
      'header_normal_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-header-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-header-area .menu-area.style-9' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'header_normal_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-header-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'header_sticky_tab',
      [
        'label' => esc_html__('Sticky', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'      => 'header_sticky_background',
        'label'     => esc_html__('Background', 'tjcore'),
        'types'     => ['classic', 'gradient'],
        'selector'  => '{{WRAPPER}} .tj-header-area.sticky, {{WRAPPER}} .tj-header-area.sticky .menu-area.style-9',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name' => 'header_sticky_border',
        'label' => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-header-area.sticky, {{WRAPPER}} .tj-header-area.sticky .menu-area.style-9',
      ]
    );
    $this->add_control(
      'header_sticky_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-header-area.sticky' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'header_sticky_box_shadow',
        'label' => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-header-area.sticky',
      ]
    );
    $this->add_responsive_control(
      'header_sticky_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-header-area.sticky' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-header-area.sticky .menu-area.style-9' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'header_sticky_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-header-area.sticky' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // logo style
    $this->start_controls_section(
      '_header_logo_style',
      [
        'label' => esc_html__('Logo', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_logo_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .logo-area a img' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_logo_max_width',
      [
        'label' => esc_html__('Max Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .logo-area a img' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_logo_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .logo-area a img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_logo_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .logo-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->end_controls_section();

    // Navigation style
    $this->start_controls_section(
      '_header_nav_style',
      [
        'label' => esc_html__('Nav Menu', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'nav_menu_typography',
        'selector' => '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li > a',
      ]
    );
    $this->start_controls_tabs('nav_style_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'nav_normal_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li > a::after' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Text Color', 'tjcore'),
          ]
        ],
        'name' => 'nav_normal_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li > a, {{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li > a::after',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'nav_hover_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li:hover > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.menu-item-has-children:hover > a::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.has-dropdown:hover > a::after' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Text Color', 'tjcore'),
          ]
        ],
        'name' => 'nav_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li:hover > a, 
        {{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.menu-item-has-children:hover > a::after, 
        {{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.has-dropdown:hover > a::after',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'nav_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'nav_active_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-item > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-ancestor > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-item > a::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-ancestor > a::after' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Text Color', 'tjcore'),
          ]
        ],
        'name' => 'nav_active_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-item > a, 
        {{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-ancestor > a, 
        {{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-item > a::after, 
        {{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li.current-menu-ancestor > a::after',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'nav_vertical_padding',
      [
        'label' => esc_html__('Vertical Padding', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li > a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
        ],
        'separator' => "before"
      ]
    );
    $this->add_responsive_control(
      'nav_space_between',
      [
        'label' => esc_html__('Space Between', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu)' => 'column-gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // dropdown
    $this->start_controls_section(
      '_header_dropdown_style',
      [
        'label' => esc_html__('Dropdown', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'important_note',
      [
        'label' => esc_html__('Important Note', 'tjcore'),
        'type' => Controls_Manager::RAW_HTML,
        'raw' => esc_html__('On desktop, this will affect the submenu.', 'tjcore'),
        'content_classes' => 'elementor-descriptor',
        'show_label' => false,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'      => 'submenu_background',
        'label'     => esc_html__('Background', 'tjcore'),
        'types'     => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector'  => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu',
      ]
    );
    $this->add_responsive_control(
      'submenu_border_solid_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .style-9 .tj-menu-area ul > li > .sub-menu::before' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Border Color', 'tjcore'),
          ]
        ],
        'name' => 'submenu_border_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu::before',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->add_responsive_control(
      'submenu_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'submenu_box_shadow',
        'label' => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu',
      ]
    );
    $this->add_responsive_control(
      'submenu_distance',
      [
        'label' => esc_html__('Distance', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul:not(.sub-menu) > li:hover > .sub-menu' => 'top: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'submenu_typography',
        'selector' => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a',
        'separator' => 'before',
      ]
    );
    $this->start_controls_tabs('submenu_style_tabs');
    $this->start_controls_tab(
      'submenu_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'submenu_normal_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a::after' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Text Color', 'tjcore'),
          ]
        ],
        'name' => 'submenu_normal_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a, {{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a::after',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'submenu_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'submenu_hover_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li:hover > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .style-9 .tj-menu-area ul > li > .sub-menu > li > a::before' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.menu-item-has-children:hover > a::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.has-dropdown:hover > a::after' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Text Color', 'tjcore'),
          ]
        ],
        'name' => 'submenu_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li:hover > a, 
        {{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a::before, 
        {{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.menu-item-has-children:hover > a::after, 
        {{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.has-dropdown:hover > a::after',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'submenu_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'submenu_active_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.current-menu-item > a' => 'color: {{VALUE}} !important',
          '{{WRAPPER}} .style-9 .tj-menu-area ul > li > .sub-menu > li.current-menu-item > a::before' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.menu-item-has-children.current-menu-item > a::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.has-dropdown.current-menu-item > a::after' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Text Color', 'tjcore'),
          ]
        ],
        'name' => 'submenu_active_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li.current-menu-item > a',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'submenu_horizontal_padding',
      [
        'label' => esc_html__('Horizontal Padding', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
        ],
        'separator' => "before"
      ]
    );
    $this->add_responsive_control(
      'submenu_vertical_padding',
      [
        'label' => esc_html__('Vertical Padding', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-menu-area ul > li > .sub-menu > li > a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // header button
    $this->start_controls_section(
      '_header_btn',
      [
        'label' => __('Header Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_header_btn' => 'yes'
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'header_btn_typography',
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn, {{WRAPPER}} .header-content-area .tj-black-btn, {{WRAPPER}} .tj-black-btn-two',
      ]
    );
    $this->start_controls_tabs('header_btn_tabs');
    $this->start_controls_tab(
      'header_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'header_btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-content-area .tj-secondary-btn span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-content-area .tj-black-btn span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-two' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-two i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Background Color', 'tjcore'),
          ]
        ],
        'name' => 'header_btn_background_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn span, {{WRAPPER}} .header-content-area .tj-black-btn, {{WRAPPER}} .tj-black-btn-two',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Border Color', 'tjcore'),
          ]
        ],
        'name' => 'header_btn_border_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn, {{WRAPPER}} .header-content-area .tj-black-btn',
        'condition' => [
          'tj_design_style' => '1'
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'header_btn_box_shadow',
        'label' => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn, {{WRAPPER}} .header-content-area .tj-black-btn, {{WRAPPER}} .tj-black-btn-two',
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'header_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'header_btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-content-area .tj-secondary-btn:hover span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-content-area .tj-black-btn:hover span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-two:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-two:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Background Color', 'tjcore'),
          ]
        ],
        'name' => 'header_btn_background_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn:hover span, {{WRAPPER}} .header-content-area .tj-black-btn::before, {{WRAPPER}} .tj-black-btn-two::after',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Border Color', 'tjcore'),
          ]
        ],
        'name' => 'header_btn_border_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn:hover',
        'condition' => [
          'tj_design_style' => '1'
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'header_btn_hover_box_shadow',
        'label' => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .header-content-area .tj-secondary-btn:hover, {{WRAPPER}} .header-content-area .tj-black-btn:hover, {{WRAPPER}} .tj-black-btn-two:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'header_btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-content-area .tj-secondary-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .header-content-area .tj-secondary-btn span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .header-content-area .tj-black-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-two::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-content-area .tj-secondary-btn span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .header-content-area .tj-black-btn'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-two'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-content-area .tj-secondary-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .header-content-area .tj-black-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .header-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Toggle Button
    $this->start_controls_section(
      '_header_toggle_btn_style',
      [
        'label' => esc_html__('Toggle Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('toggle_tabs');
    $this->start_controls_tab(
      'toggle_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'toggle_btn_normal_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menuBar' => 'color: {{VALUE}}',
          '{{WRAPPER}} .menuBar > span' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'toggle_btn_normal_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menuBar' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'toggle_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'toggle_btn_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menuBar:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .menuBar:hover > span' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'toggle_btn_hover_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menuBar:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'toggle_btn_size',
      [
        'label' => esc_html__('Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .menuBar' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'toggle_btn_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .menuBar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'toggle_btn_border_radius',
      [
        'label' => esc_html__('Radius', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .menuBar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Hamburger
    $this->start_controls_section(
      '_hamburger_style',
      [
        'label' => esc_html__('Hamburger', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'hamburger_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'hamburger_background',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-offcanvas-area',
      ]
    );
    $this->add_responsive_control(
      'hamburger_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'hamburger_overlay_color',
      [
        'label'     => esc_html__('Overlay Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-overlay-canvas' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    // logo
    $this->add_control(
      'hamburger_options_1',
      [
        'label' => esc_html__('Hamburger Logo', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'hamburger_logo_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .logo-area' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_logo_max_width',
      [
        'label' => esc_html__('Max Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .logo-area' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_logo_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 500,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .logo-area .mobile-logo img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Hamburger Search
    $this->start_controls_section(
      '_hamburger_search_style',
      [
        'label' => esc_html__('Search', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_mobile_search' => 'yes'
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'search_field_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-search-box form input[type=search]',
      ]
    );
    $this->add_responsive_control(
      'search_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form input[type=search]'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form input[type=search]::-moz-placeholder'                                            => 'color: {{VALUE}}',

          '{{WRAPPER}} .tj-search-box form input[type=search]::-ms-input-placeholder'                                       => 'color: {{VALUE}}',

          '{{WRAPPER}} .tj-search-box form input[type=search]::-webkit-input-placeholder'                                   => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form input[type=search]' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_field_radius',
      [
        'label'      => esc_html__('Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-search-box form input[type=search]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'search_field_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-search-box form input[type=search]',
      ]
    );
    $this->add_responsive_control(
      'search_field_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-search-box form input[type=search]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_field_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-search-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_filed_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 100,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-search-box form input[type=search]' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // search button
    $this->add_control(
      'search_options_1',
      [
        'label' => esc_html__('Search Button', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'search_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form button' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('search_tabs');
    $this->start_controls_tab(
      'search_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'search_btn_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form button'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form button'  => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'search_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'search_btn_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form button:hover'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_btn_hover_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-search-box form button:hover'  => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'search_btn_radius',
      [
        'label'      => esc_html__('Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-search-box form button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'search_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-search-box form button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Hamburger menu
    $this->start_controls_section(
      '_hamburger_menu_style',
      [
        'label' => esc_html__('Hamburger Menu', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'hamburger_menu_typography',
        'selector' => '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li > a',
      ]
    );
    $this->start_controls_tabs('hamburger_menu_style_tabs');
    $this->start_controls_tab(
      'hamburger_menu_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_menu_normal_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li > a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li > a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'hamburger_menu_normal_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li > a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'hamburger_menu_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_menu_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li:hover > a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li:hover > a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'hamburger_menu_hover_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li:hover > a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'hamburger_menu_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_menu_active_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li.current-menu-ancestor > a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li.current-menu-ancestor > a i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li.current-menu-item > a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li.current-menu-item > a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'hamburger_menu_active_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li.current-menu-ancestor > a' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li.current-menu-item > a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'hamburger_menu_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li > a' => 'border-color: {{VALUE}}',
        ],
        'separator' => "before"
      ]
    );
    $this->add_responsive_control(
      'hamburger_menu_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .mobile-navbar-menu.mean-container .mean-nav ul li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // contact Info
    $this->start_controls_section(
      '_hamburger_contact_style',
      [
        'label' => esc_html__('Contact Info', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_mobile_contact' => 'yes'
        ]
      ]
    );
    $this->add_responsive_control(
      'contact_info_gap',
      [
        'label' => esc_html__('Distance', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul' => 'gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // icon
    $this->add_control(
      'contact_options_1',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'contact_icon_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'contact_icon_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'contact_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->start_controls_tabs('contact_icon_tabs');
    $this->start_controls_tab(
      'contact_icon_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'contact_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'contact_icon_bg_color',
        'types' => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span',
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'contact_icon_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'contact_icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li:hover span i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'contact_icon_bg_hover_color',
        'types' => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li:hover span',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'contact_icon_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'contact_icon_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // label
    $this->add_control(
      'contact_options_2',
      [
        'label' => esc_html__('Label', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'contact_label_typography',
        'selector' => '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li p, {{WRAPPER}}  .tj-offcanvas-area .mobile-contact ul li a',
      ]
    );
    $this->add_control(
      'contact_label_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li p' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li p' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'contact_label_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'contact_label_hover_color',
      [
        'label'     => esc_html__('Hover Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-contact ul li:hover a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // socials
    $this->start_controls_section(
      '_hamburger_socials_style',
      [
        'label' => esc_html__('Socials', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_mobile_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'hamburger_social_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'hamburger_social_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'hamburger_social_gap',
      [
        'label' => esc_html__('Gap', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul' => 'gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'hamburger_social_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->start_controls_tabs('hamburger_social_tabs');

    $this->start_controls_tab(
      'hamburger_social_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'hamburger_social_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_social_icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'hamburger_social_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'hamburger_social_icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_social_icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'hamburger_social_icon_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-offcanvas-area .mobile-share ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();

    // Hamburger button
    $this->start_controls_section(
      '_hamburger_button_style',
      [
        'label' => esc_html__('Hamburger Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_mobile_header_btn' => 'yes'
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'hamburger_btn_typography',
        'selector' => '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn',
      ]
    );
    $this->start_controls_tabs('hamburger_btn_tabs');
    $this->start_controls_tab(
      'hamburger_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Background Color', 'tjcore'),
          ]
        ],
        'name' => 'hamburger_btn_background_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn',
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'hamburger_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => esc_html__('Background Color', 'tjcore'),
          ]
        ],
        'name' => 'hamburger_btn_background_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn::before',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'hamburger_btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'hamburger_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-offcanvas-area .tj-black-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/header/style-' . $tj_design_style . '.php';
?>

<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Header());
