<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Hero Banner.
 */
class TJ_Hero_Banner extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-hero-banner';
  }

  // widget title.
  public function get_title() {
    return __('TJ Hero Banner', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-banner tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'hero',
      'hero banner',
      'tj hero',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Banner Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Banner Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_hero_banner_title
    $this->start_controls_section(
      '_tj_hero_banner_content',
      [
        'label' => esc_html__('Banner Content', 'tjcore'),

      ]
    );
    $this->add_control(
      'tj_hero_banner_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Section Subtitle', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_subtitle_animation',
      [
        'label'        => esc_html__('Enable Subtitle Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_subtitle_animation'    => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_subtitle_animation'    => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => esc_html__('Section Title', 'tjcore'),
        'rows'      => '3',
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_title_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'is_hero_banner_content',
      [
        'label'        => esc_html__('Is Section Content?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_hero_banner_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'rows'      => 8,
        'condition' => [
          'is_hero_banner_content' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_content_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'is_hero_banner_content' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'is_hero_banner_content' => 'yes',
          'tj_content_animation'   => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'is_hero_banner_content' => 'yes',
          'tj_content_animation'   => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_title_tag',
      [
        'label'     => esc_html__('Title HTML Tag', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default'   => 'h1',
        'toggle'    => false,
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'tj_hero_banner_alignment',
      [
        'label'     => esc_html__('Alignment', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'start'  => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'end'    => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'   => 'center',
        'separator' => 'before',
        'condition' => [
          'tj_design_style' => '2',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '__tj_hero_banner_button',
      [
        'label'     => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_hero_banner_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Read More', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => '',
          'library' => '',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_hero_banner_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_hero_banner_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_hero_banner_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation',
      [
        'label'        => esc_html__('Enable Button Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_button_show'      => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_button_show'      => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // thumbnail
    $this->start_controls_section(
      '__tj_hero_banner_thumbnails',
      [
        'label' => esc_html__('Thumbnails', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_hero_banner_image',
      [
        'label'   => esc_html__('Hero Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['2', '3', '4', '5', '6', '7'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_overlay',
      [
        'label'     => esc_html__('Background Overlay', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
          '{{WRAPPER}} .tj-hero-section-three .hero-lg-image::before' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Background Overlay', 'tjcore'),
          ],
        ],
        'name' => 'tj_hero3_banner_overlay',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-hero-section.hero-style-four::before, {{WRAPPER}} .tj-hero-section.style-6::before, {{WRAPPER}} .tj-hero-section.hero-style-five::before',
        'condition' => [
          'tj_design_style' => ['3', '4', '5']
        ]
      ]
    );
    $this->add_control(
      'tj_hero_banner_left_image',
      [
        'label'   => esc_html__('Banner Right Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['1', '5'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_right_image',
      [
        'label'   => esc_html__('Banner Left Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['1', '5'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_bottom_image',
      [
        'label'   => esc_html__('Banner Bottom Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['5'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero9_image_1',
      [
        'label'   => esc_html__('Hero Image 01', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero9_image_2',
      [
        'label'   => esc_html__('Hero Image 02', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero9_image_3',
      [
        'label'   => esc_html__('Hero Image 03', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero9_image_4',
      [
        'label'   => esc_html__('Hero Image 04', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero9_image_5',
      [
        'label'   => esc_html__('Hero Image 05', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero9_image_6',
      [
        'label'   => esc_html__('Hero Image 06', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_animation',
      [
        'label'        => esc_html__('Enable Image Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition' => [
          'tj_design_style' => ['1', '6', '7', '8'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_design_style' => ['1', '6', '7', '8'],
          'tj_image_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_image_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_design_style' => ['1', '6', '7'],
          'tj_image_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // Scroll Down
    $this->start_controls_section(
      '__tj_hero_banner_scroll_down',
      [
        'label' => esc_html__('Scroll Down', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => '1',
        ],
      ]
    );
    $this->add_control(
      'tj_scroll_down_show',
      [
        'label'        => esc_html__('Show scroll down?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_scroll_down_link',
      [
        'label'     => esc_html__('Link', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('#', 'tjcore'),
        'condition' => [
          'tj_scroll_down_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_scroll_down_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'scroll_down_icon',
        'default'          => [
          'value'   => 'flaticon-left-click',
          'library' => 'flaticon',
        ],
        'condition'        => [
          'tj_scroll_down_show' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // banner shapes
    $this->start_controls_section(
      '__tj_hero_banner_shapes',
      [
        'label' => esc_html__('Banner Shapes', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => '4'
        ]
      ]
    );
    $this->add_control(
      'tj_shapes_show',
      [
        'label'        => esc_html__('Show banner shapes?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_hero_banner_bg_shape',
      [
        'label'   => esc_html__('Banner BG Shape', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style' => ['6'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_shape_1',
      [
        'label'   => esc_html__('Banner Shape 1', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_shape_2',
      [
        'label'   => esc_html__('Banner Shape 2', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style!' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_shape_3',
      [
        'label'   => esc_html__('Banner Shape 3', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style!' => ['3', '8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_shape_4',
      [
        'label'   => esc_html__('Banner Shape 4', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style!' => ['3', '5', '6', '7', '8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_shape_5',
      [
        'label'   => esc_html__('Banner Shape 5', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style!' => ['3', '5', '6', '7', '8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_shape_6',
      [
        'label'   => esc_html__('Banner Shape 6', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
          'tj_design_style' => '1',
        ],
      ]
    );
    $this->end_controls_section();

    // banner icons
    $this->start_controls_section(
      '__tj_hero_banner_icons',
      [
        'label' => esc_html__('Banner Icons', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => ['7', '8']
        ]
      ]
    );
    $this->add_control(
      'tj_banner_icons_show',
      [
        'label'        => esc_html__('Show banner icons?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_1',
      [
        'label'   => esc_html__('Hero Icon 1', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_2',
      [
        'label'   => esc_html__('Hero Icon 2', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_3',
      [
        'label'   => esc_html__('Hero Icon 3', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_4',
      [
        'label'   => esc_html__('Hero Icon 4', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_5',
      [
        'label'   => esc_html__('Hero Icon 5', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
          'tj_design_style!' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_6',
      [
        'label'   => esc_html__('Hero Icon 6', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
          'tj_design_style!' => ['8'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_icon_7',
      [
        'label'   => esc_html__('Hero Icon 7', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_banner_icons_show' => 'yes',
          'tj_design_style!' => ['8'],
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj-hero-section, {{WRAPPER}} .tj-hero-section-three, {{WRAPPER}} .tj-hero-section .hero-scroll',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Background Overlay', 'tjcore'),
          ],
        ],
        'name' => 'tj_hero6_banner_overlay',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-hero-section.style-7::after',
        'condition' => [
          'tj_design_style' => ['6']
        ]
      ]
    );
    $this->add_control(
      'tj_section_background_overlay',
      [
        'label'     => esc_html__('Background Overlay', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
          '{{WRAPPER}} .tj-hero-section::after' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-hero-section-three::after' => 'background: {{VALUE}}',
        ],
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ["3", "4", "6", "7"]
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-three' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_subtitle',
      [
        'label'     => esc_html__('Subtitle', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .hero-left-content .hero-sub-title, {{WRAPPER}} .tj-sec-heading .white-sub-title, {{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .subtitle, {{WRAPPER}} .hero_content_wrap .subtitle, {{WRAPPER}} .content-area .sub-title, {{WRAPPER}} .tj-sec-heading .sub-title',
      ]
    );
    $this->add_control(
      'tj_subtitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-left-content .hero-sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading .white-sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .subtitle' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero_content_wrap .subtitle' => 'color: {{VALUE}}',
          '{{WRAPPER}} .content-area .sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-left-content .hero-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading .white-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero_content_wrap .subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .content-area .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-left-content .hero-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading .white-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero_content_wrap .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .content-area .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .hero-left-content .hero-title, {{WRAPPER}} .hero-content-area .title, {{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .title, {{WRAPPER}} .hero_content_wrap .title, {{WRAPPER}} .content-area .title, {{WRAPPER}} .tj-sec-heading .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Title Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-left-content .hero-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-content-area .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero_content_wrap .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .content-area .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_span_color',
      [
        'label'     => __('Title Span Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-content-area .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero_content_wrap .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .content-area .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading .title span' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2', '4', '6', '7', '8']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Title Gradient', 'tjcore'),
          ],
        ],
        'name' => 'tj_title_gradient_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .hero-left-content .hero-title span',
        'condition' => [
          'tj_design_style' => '1'
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-left-content .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-content-area .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero_content_wrap .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .content-area .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-left-content .hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-content-area .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero_content_wrap .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .content-area .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Desc', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_hero_banner_content' => 'yes',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .hero-left-content p, {{WRAPPER}} .tj-hero-section-three .tj-sec-heading .desc p, .tj-hero-section.style-6 .hero_content_wrap .desc, {{WRAPPER}} .hero_content_wrap .desc, {{WRAPPER}} .content-area .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-left-content p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-hero-section-three .tj-sec-heading .desc p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero_content_wrap .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .content-area .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-left-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-three .tj-sec-heading .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.hero-style-five .hero-descrition .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero_content_wrap .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .content-area .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-left-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-three .tj-sec-heading .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.style-6 .hero_content_wrap .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section.hero-style-five .hero-descrition .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero_content_wrap .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .content-area .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      'section_tab_button',
      [
        'label'     => esc_html__('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .hero-button .tj-primary-btn, {{WRAPPER}} .hero-button .tj-black-btn, {{WRAPPER}} .hero-button .tj-black-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-three, {{WRAPPER}} .hero-button .tj-black-btn-three',
      ]
    );
    $this->start_controls_tabs('style_tabs_1');
    $this->start_controls_tab(
      'btn_1_button_style_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_1_label_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-button .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-primary-btn i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-two' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-two i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-two' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-two i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-three' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-three i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-three' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-three i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_1_bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .hero-button .tj-primary-btn, {{WRAPPER}} .hero-button .tj-black-btn, {{WRAPPER}} .hero-button .tj-black-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-three, {{WRAPPER}} .hero-button .tj-black-btn-three',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'btn_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .hero-button .tj-primary-btn, {{WRAPPER}} .hero-button .tj-black-btn, {{WRAPPER}} .hero-button .tj-black-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-three {{WRAPPER}} .hero-button .tj-black-btn-three',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'btn_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .hero-button .tj-primary-btn, {{WRAPPER}} .hero-button .tj-black-btn, {{WRAPPER}} .hero-button .tj-black-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-two, {{WRAPPER}} .hero-button .tj-white-btn-three, {{WRAPPER}} .hero-button .tj-black-btn-three',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'btn_1_button_style_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_label_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-button .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-primary-btn:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-two:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-two:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-two:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-two:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-three:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-white-btn-three:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-three:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-button .tj-black-btn-three:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_hover__bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}}.hero-button .tj-primary-btn:hover, {{WRAPPER}} .hero-button .tj-black-btn:hover, {{WRAPPER}} .hero-button .tj-black-btn-two:hover, {{WRAPPER}} .hero-button .tj-white-btn-two:hover, {{WRAPPER}} .hero-button .tj-white-btn-three::before, {{WRAPPER}} .hero-button .tj-black-btn-three::after',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'btn_hover_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .hero-button .tj-primary-btn:hover, {{WRAPPER}} .hero-button .tj-black-btn:hover, {{WRAPPER}} .hero-button .tj-black-btn-two:hover, {{WRAPPER}} .hero-button .tj-white-btn-two:hover, {{WRAPPER}} .hero-button .tj-white-btn-three:hover, {{WRAPPER}} .hero-button .tj-black-btn-three:hover',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'btn_hover_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .hero-button .tj-primary-btn:hover, {{WRAPPER}} .hero-button .tj-black-btn:hover, {{WRAPPER}} .hero-button .tj-black-btn-two:hover, {{WRAPPER}} .hero-button .tj-white-btn-two:hover, {{WRAPPER}} .hero-button .tj-white-btn-three:hover, {{WRAPPER}} .hero-button .tj-black-btn-three:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-button .tj-primary-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-button .tj-black-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-button .tj-black-btn-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-button .tj-white-btn-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-button .tj-white-btn-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-button .tj-black-btn-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'tj_btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_banner_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/hero-banner/style-' . $tj_banner_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Hero_Banner());
