<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Hero Slider.
 */
class TJ_Hero_Slider extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-hero-slider';
  }

  // widget title.
  public function get_title() {
    return __('TJ Hero Slider', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-slides tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'slides',
      'sliders',
      'tj slider',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Slider Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Slider Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '__tj_slider_content',
      [
        'label' => esc_html__('Slider Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_slider_img',
      [
        'label'   => esc_html__('Background Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'tj_slider_img_overlay',
      [
        'label'     => esc_html__('Background Overlay', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'default'   => "",
        'selectors' => [
          '{{WRAPPER}} .hero-wrapper.hero-1 .single-hero-slider:before' => 'background: {{VALUE}}',
        ],
        'separator' => "after",
      ]
    );
    $repeater->add_control(
      'tj_slider_sub_title',
      [
        'label'       => esc_html__('Sub Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => esc_html__('Collaboration With Chat', 'tjcore'),
        'placeholder' => esc_html__('Insert your slider sub title here.', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
        'ai'          => [
          'active' => false,
        ],
      ]
    );
    $repeater->add_control(
      'tj_slider_title',
      [
        'label'       => esc_html__('Heading', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default'     => esc_html__('Better Design For Digital Products. ', 'tjcore'),
        'placeholder' => esc_html__('Insert your slider heading here.', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
        'ai'          => [
          'active' => false,
        ],
      ]
    );
    $repeater->add_control(
      'tj_slider_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more.', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_slider_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h1',
        'toggle'  => false,
        'separator' => 'before'
      ]
    );
    $repeater->add_control(
      'tj_button_switcher',
      [
        'label'        => esc_html__('Show Button', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Show', 'tjcore'),
        'label_off'    => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Get Started', 'tjcore'),
        'label_block' => true,
        'condition'   => [
          'tj_button_switcher' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
        'condition'   => [
          'tj_button_switcher' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'               => '#',
          'is_external'       => true,
          'nofollow'          => true,
          'custom_attributes' => '',
        ],
        'condition'     => [
          'tj_btn_link_type'   => '1',
          'tj_button_switcher' => 'yes',
        ],
        'label_block'   => true,
      ]
    );
    $repeater->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type'   => '2',
          'tj_button_switcher' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'slider_list',
      [
        'label'       => esc_html__('Slider List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_slider_sub_title' => esc_html__('Collaboration With Chat', 'tjcore'),
            'tj_slider_title'     => esc_html__('Better Design For Digital Products. ', 'tjcore'),
            'tj_slider_desc'     => esc_html__('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more.. ', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_slider_sub_title }}}',
      ]
    );
    $this->end_controls_section();

    // slider shape
    $this->start_controls_section(
      '__tj_slider_shapes',
      [
        'label' => esc_html__('Slider Shape', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_slider_shape',
      [
        'label'   => esc_html__('Shape', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'             => esc_html__('Is Loop?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'             => esc_html__('Is Autoplay?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label' => esc_html__('Autoplay Delay', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'description'       => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min' => 1000,
        'max' => 10000,
        'step' => 100,
        'default' => 5000,
        'condition' => [
          'slide_autoplay' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'             => esc_html__('Is Dots?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to show slider Dots navigation?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_slider_subtitle',
      [
        'label'     => __('Subtitle', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'subtitle_typography',
        'selector' => '{{WRAPPER}} .swiper-slide .white-sub-title',
      ]
    );
    $this->add_control(
      'subtitle_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper-slide .white-sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'subtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .swiper-slide .white-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .swiper-slide .white-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_slider_title',
      [
        'label' => __('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'title_typography',
        'selector' => '{{WRAPPER}} .swiper-slide .title',
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper-slide .title'                                           => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .swiper-slide .title'                                           => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .swiper-slide .title'                                           => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // description
    $this->start_controls_section(
      '_slider_desc',
      [
        'label'     => __('Description', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'desc_typography',
        'selector' => '{{WRAPPER}} .hero-content-area .desc p',
      ]
    );
    $this->add_control(
      'desc_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-content-area .desc p' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'desc_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hero-content-area .desc p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'desc_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hero-content-area .desc p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_heading_btn',
      [
        'label'     => __('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs(
      'btn_tabs'
    );
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_background_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_background_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_border_hover_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'btn_border_style',
      [
        'label'     => esc_html__('Border Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''       => esc_html__('Default', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
          'solid'  => esc_html__('Solid', 'tjcore'),
          'dashed' => esc_html__('Dashed', 'tjcore'),
          'dotted' => esc_html__('Dotted', 'tjcore'),
          'double' => esc_html__('Double', 'tjcore'),
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-style: {{VALUE}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_border_width',
      [
        'label'      => esc_html__('Border Width', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_control(
      'btn_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-primary-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_slider_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/hero-slider/style-' . $tj_slider_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Hero_Slider());
