<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Info List.
 */
class TJ_Info_List extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-info-list';
  }

  // widget title.
  public function get_title() {
    return __('TJ Info List', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-editor-list-ul tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'list',
      'info list',
      'tj list',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls() {
    // tj_content_tab
    $this->start_controls_section(
      'tj_content_tab',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $teamList = new Repeater();
    $teamList->add_control(
      'list_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Position:', 'tjcore'),
        'label_block' => true,
      ]
    );
    $teamList->add_control(
      'list_value',
      [
        'label' => esc_html__('Value', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Co Founder', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'team_details_list',
      [
        'label' => esc_html__('Details List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $teamList->get_controls(),
        'default' => [
          [
            'list_title' => esc_html__('Position:', 'tjcore'),
            'list_value' => esc_html__('Co Founder', 'tjcore'),
          ],
          [
            'list_title' => esc_html__('Practice Area:', 'tjcore'),
            'list_value' => esc_html__('Real Estate Agent', 'tjcore'),
          ],
          [
            'list_title' => esc_html__('Experience:', 'tjcore'),
            'list_value' => esc_html__('12 Years', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ list_title }}}',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );

    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_content_style',
      [
        'label' => esc_html__('List Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'list_border_color',
      [
        'label' => esc_html__('Border Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .plan-content ul li:not(:last-of-type)' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => '1'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .plan-content ul li:not(:last-of-type)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .team-details-list li:not(:last-of-type)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'list_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .plan-content ul li:not(:last-of-type)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .team-details-list li:not(:last-of-type)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // key
    $this->start_controls_section(
      'list_key_style',
      [
        'label' => esc_html__('List Key', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'list_key_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .plan-content ul li .key, {{WRAPPER}} .team-details-list li .desc',
      ]
    );
    $this->add_responsive_control(
      'list_key_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .plan-content ul li .key' => 'color: {{VALUE}}',
          '{{WRAPPER}} .team-details-list li .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // value
    $this->start_controls_section(
      'list_value_style',
      [
        'label' => esc_html__('List Value', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'list_value_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .plan-content ul li .value, {{WRAPPER}} .team-details-list li .value',
      ]
    );
    $this->add_responsive_control(
      'list_value_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .plan-content ul li .value' => 'color: {{VALUE}}',
          '{{WRAPPER}} .team-details-list li .value' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style   = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/info-list/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Info_List());
