<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Latest Posts.
 */
class TJ_Latest_Posts extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-latest-posts';
  }

  // widget title.
  public function get_title() {
    return __('TJ Latest Posts', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-post-list tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'latest-post',
      'posts',
      'tj post',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Post Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Post Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
          9 => esc_html__('Style 09', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Post Query
    $this->start_controls_section(
      'tj_post_query',
      [
        'label' => esc_html__('Post Query', 'tjcore'),
      ]
    );

    $post_type = 'post';
    $taxonomy  = 'category';

    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Posts Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '3',
      ]
    );
    $this->add_control(
      'category',
      [
        'label'       => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label'       => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );
    $this->add_control(
      'ignore_sticky_posts',
      [
        'label'        => esc_html__('Ignore Sticky Posts', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Count', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '9',
      ]
    );
    $this->add_control(
      'tj_post_content',
      [
        'label'        => __('Content', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'condition' => [
          'tj_design_style!' => ["3", "5", '6']
        ]
      ]
    );
    $this->add_control(
      'tj_post_content_limit',
      [
        'label'       => __('Content Limit', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => '20',
        'dynamic'     => [
          'active' => true,
        ],
        'condition'   => [
          'tj_post_content'  => 'yes',
          'tj_design_style!' => ["3", "5", "6"]
        ],
      ]
    );
    $this->add_control(
      'tj_post_button',
      [
        'label'        => __('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_post_button_text',
      [
        'label'     => __('Button Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Read More', 'tjcore'),
        'condition'   => [
          'tj_post_button'  => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Grid Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'      => 'before',
      ]
    );
    $this->end_controls_section();

    // post meta
    $this->start_controls_section(
      'tj_post_meta',
      [
        'label' => esc_html__('Post Meta', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ["3", "5"]
        ]
      ]
    );
    $this->add_control(
      'tj_post_author',
      [
        'label'        => esc_html__('Post Author', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_date',
      [
        'label'        => esc_html__('Post Date', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_comment',
      [
        'label'        => esc_html__('Post Comment', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ["8", "9"]
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Hover Overlay', 'tjcore')
          ],
        ],
        'name' => 'tj_gradient_hover_overlay',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-blog-item.style-8 .blog-image::after, {{WRAPPER}} .tj_blog_item.style-9 .blog_img > a::after',
        'condition' => [
          'tj_design_style' => ['8', '9 ']
        ]
      ]
    );
    $this->end_controls_section();

    // meta
    $this->start_controls_section(
      '_section_style_meta',
      [
        'label' => esc_html__('Meta', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_meta_typography',
        'selector' => '{{WRAPPER}} .blog-meta > span, {{WRAPPER}} .blog-meta-two span, {{WRAPPER}} .blog-meta-three span',
      ]
    );
    $this->add_control(
      'tj_meta_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-meta > span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .blog-meta-two span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .blog-meta-three span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_meta_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-meta > span i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .blog-meta-two span i' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ["3", "6"]
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_meta_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-meta > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .blog-meta-two span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .blog-meta-three span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_meta_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-meta > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .blog-meta-two span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .blog-meta-three span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-blog-item .blog-content-area .title-link a, {{WRAPPER}} .tj-blog-item-two .blog-content-area .title-link a, {{WRAPPER}} .tj-blog-item-three .blog-content-area .title-link a, {{WRAPPER}} .tj-blog-item-four .blog-content-area .title-link a, {{WRAPPER}} .tj_blog_item .blog_content .title a',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-blog-item .blog-content-area .title-link a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-blog-item-two .blog-content-area .title-link a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-blog-item-three .blog-content-area .title-link a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-blog-item-four .blog-content-area .title-link a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_blog_item .blog_content .title a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-blog-item .blog-content-area .title-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-two .blog-content-area .title-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-three .blog-content-area .title-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-four .blog-content-area .title-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_blog_item .blog_content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-blog-item .blog-content-area .title-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-two .blog-content-area .title-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-four .blog-content-area .title-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_blog_item .blog_content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_post_content' => 'yes',
          'tj_design_style!' => ['3', '5', '6', '9'],
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .tj-blog-item .blog-content-area .desc, {{WRAPPER}} .tj-blog-item-two .blog-content-area .desc, {{WRAPPER}} .tj-blog-item-four .blog-content-area .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-blog-item .blog-content-area .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-blog-item-two .blog-content-area .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-blog-item-four .blog-content-area .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-blog-item .blog-content-area .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-two .blog-content-area .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-four .blog-content-area .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-blog-item .blog-content-area .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-two .blog-content-area .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-blog-item-four .blog-content-area .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //  button
    $this->start_controls_section(
      '_style_btn',
      [
        'label'     => __('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_post_content' => "yes",
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border, {{WRAPPER}} .tj-black-btn, {{WRAPPER}} .tj-white-btn, {{WRAPPER}} .tj-transparent-btn-three, {{WRAPPER}} .tj-black-btn-four, {{WRAPPER}} .tj-black-btn-three',
      ]
    );
    $this->start_controls_tabs(
      'btn_tabs'
    );
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-white-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-transparent-btn-three' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-four span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_background_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-white-btn' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-transparent-btn-three' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-four' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border:hover span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-white-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-transparent-btn-three:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-transparent-btn-three:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-four:hover span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-four:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Background Color', 'tjcore')
          ],
        ],
        'name' => 'btn_background_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border, {{WRAPPER}} .tj-secondary-btn.btn-border:hover span, {{WRAPPER}} .tj-black-btn::before, {{WRAPPER}} .tj-white-btn, {{WRAPPER}} .tj-transparent-btn-three::before, {{WRAPPER}} .tj-black-btn-four:hover::after, {{WRAPPER}} .tj-black-btn-three::after',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-white-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-transparent-btn-three' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-four' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-three' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-three::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-white-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-transparent-btn-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-four' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-blog-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-read-more-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-white-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-transparent-btn-three' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-four' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .blog-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/latest-posts/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Latest_Posts());
